/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.util;

import io.fabric8.maven.docker.access.util.ExternalCommand;
import io.fabric8.maven.docker.util.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class EnvCommand
extends ExternalCommand {
    private final Map<String, String> env = new HashMap<String, String>();
    private final String prefix;
    private final Pattern ENV_VAR_PATTERN = Pattern.compile("^\\s*(?<key>[^=]+)=\"?(?<value>.*?)\"?\\s*$");

    public EnvCommand(Logger log, String prefix) {
        super(log);
        this.prefix = prefix;
    }

    @Override
    protected void processLine(String line) {
        if (this.log.isDebugEnabled()) {
            this.log.verbose("%s", line);
        }
        if (line.startsWith(this.prefix)) {
            this.setEnvironmentVariable(line.substring(this.prefix.length()));
        }
    }

    private void setEnvironmentVariable(String line) {
        Matcher matcher = this.ENV_VAR_PATTERN.matcher(line);
        if (matcher.matches()) {
            String key = matcher.group("key");
            String value = matcher.group("value");
            this.log.debug("Env: %s=%s", key, value);
            this.env.put(key, value);
        }
    }

    public Map<String, String> getEnvironment() throws IOException {
        this.execute();
        return this.env;
    }
}

