/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.VolumeConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.VolumeService;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="volume-create", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class VolumeCreateMojo
extends AbstractDockerMojo {
    @Override
    protected void executeInternal(ServiceHub serviceHub) throws DockerAccessException, MojoExecutionException {
        if (this.getVolumes() == null) {
            this.log.info("No volume configuration found.", new Object[0]);
            return;
        }
        VolumeService volService = serviceHub.getVolumeService();
        for (VolumeConfiguration volume : this.getVolumes()) {
            this.log.info("Creating volume '%s'", volume.getName());
            volService.createVolume(volume);
        }
    }
}

