/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import java.io.Serializable;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class WaitConfiguration
implements Serializable {
    public static final String DEFAULT_HTTP_METHOD = "HEAD";
    public static final int DEFAULT_MIN_STATUS = 200;
    public static final int DEFAULT_MAX_STATUS = 399;
    public static final String DEFAULT_STATUS_RANGE = String.format("%d..%d", 200, 399);
    @Parameter
    private Integer time;
    @Parameter
    private String url;
    @Parameter
    private HttpConfiguration http;
    @Parameter
    private ExecConfiguration exec;
    @Parameter
    private TcpConfiguration tcp;
    @Parameter
    Boolean healthy;
    @Parameter
    private String log;
    @Parameter
    private Integer shutdown;
    @Parameter
    private Integer kill;
    @Parameter
    private Integer exit;

    public WaitConfiguration() {
    }

    private WaitConfiguration(Integer time, ExecConfiguration exec, HttpConfiguration http, TcpConfiguration tcp, Boolean healthy, String log, Integer shutdown, Integer kill, Integer exit) {
        this.time = time;
        this.exec = exec;
        this.http = http;
        this.tcp = tcp;
        this.healthy = healthy;
        this.log = log;
        this.shutdown = shutdown;
        this.kill = kill;
        this.exit = exit;
    }

    public Integer getTime() {
        return this.time;
    }

    public String getUrl() {
        return this.http != null ? this.http.getUrl() : this.url;
    }

    public ExecConfiguration getExec() {
        return this.exec;
    }

    public HttpConfiguration getHttp() {
        return this.http;
    }

    public TcpConfiguration getTcp() {
        return this.tcp;
    }

    public String getLog() {
        return this.log;
    }

    public Integer getExit() {
        return this.exit;
    }

    public Integer getShutdown() {
        return this.shutdown;
    }

    public Integer getKill() {
        return this.kill;
    }

    public Boolean getHealthy() {
        return this.healthy;
    }

    public static class TcpConfiguration
    implements Serializable {
        @Parameter
        private String host;
        @Parameter
        private List<Integer> ports;
        @Parameter
        private TcpConfigMode mode;

        public TcpConfiguration() {
        }

        private TcpConfiguration(TcpConfigMode mode, String host, List<Integer> ports) {
            this.mode = mode;
            this.host = host;
            this.ports = ports;
        }

        public String getHost() {
            return this.host;
        }

        public List<Integer> getPorts() {
            return this.ports;
        }

        public TcpConfigMode getMode() {
            return this.mode;
        }
    }

    public static enum TcpConfigMode {
        mapped,
        direct;

    }

    public static class HttpConfiguration
    implements Serializable {
        @Parameter
        private String url;
        @Parameter
        private String method = "HEAD";
        @Parameter
        private String status = DEFAULT_STATUS_RANGE;
        @Parameter
        private boolean allowAllHosts;

        public HttpConfiguration() {
        }

        private HttpConfiguration(String url, String method, String status) {
            this.url = url;
            this.method = method;
            this.status = status;
        }

        public String getUrl() {
            return this.url;
        }

        public String getMethod() {
            return this.method;
        }

        public String getStatus() {
            return this.status;
        }

        public boolean isAllowAllHosts() {
            return this.allowAllHosts;
        }
    }

    public static class ExecConfiguration
    implements Serializable {
        @Parameter
        private String postStart;
        @Parameter
        private String preStop;
        @Parameter
        private boolean breakOnError;

        public ExecConfiguration() {
        }

        public ExecConfiguration(String postStart, String preStop, boolean breakOnError) {
            this.postStart = postStart;
            this.preStop = preStop;
            this.breakOnError = breakOnError;
        }

        public String getPostStart() {
            return this.postStart;
        }

        public String getPreStop() {
            return this.preStop;
        }

        public boolean isBreakOnError() {
            return this.breakOnError;
        }
    }

    public static class Builder {
        private Integer time;
        private Integer shutdown;
        private Integer kill;
        private String url;
        private String log;
        private String status;
        Boolean healthy;
        private String method;
        private String preStop;
        private String postStart;
        private List<Integer> tcpPorts;
        private String tcpHost;
        private TcpConfigMode tcpMode;
        private Integer exit;
        private Boolean breakOnError = false;

        public Builder time(int time) {
            this.time = time;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder healthy(Boolean healthy) {
            this.healthy = healthy;
            return this;
        }

        public Builder log(String log) {
            this.log = log;
            return this;
        }

        public Builder shutdown(Integer shutdown) {
            this.shutdown = shutdown;
            return this;
        }

        public Builder kill(Integer kill) {
            this.kill = kill;
            return this;
        }

        public Builder exit(Integer exit) {
            this.exit = exit;
            return this;
        }

        public Builder tcpPorts(List<Integer> tcpPorts) {
            this.tcpPorts = tcpPorts;
            return this;
        }

        public Builder tcpHost(String tcpHost) {
            this.tcpHost = tcpHost;
            return this;
        }

        public Builder tcpMode(String tcpMode) {
            if (tcpMode != null) {
                this.tcpMode = TcpConfigMode.valueOf(tcpMode.toLowerCase());
            }
            return this;
        }

        public WaitConfiguration build() {
            return new WaitConfiguration(this.time, this.postStart != null || this.preStop != null ? new ExecConfiguration(this.postStart, this.preStop, this.breakOnError != null ? this.breakOnError : false) : null, this.url != null ? new HttpConfiguration(this.url, this.method, this.status) : null, this.tcpPorts != null ? new TcpConfiguration(this.tcpMode, this.tcpHost, this.tcpPorts) : null, this.healthy, this.log, this.shutdown, this.kill, this.exit);
        }

        public Builder preStop(String command) {
            this.preStop = command;
            return this;
        }

        public Builder postStart(String command) {
            this.postStart = command;
            return this;
        }

        public Builder breakOnError(Boolean stop) {
            this.breakOnError = stop;
            return this;
        }
    }
}

