/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.wait;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.log.LogGetHandle;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.wait.LogMatchCallback;
import io.fabric8.maven.docker.wait.LogWaitCheckerCallback;
import io.fabric8.maven.docker.wait.WaitChecker;
import java.util.concurrent.CountDownLatch;

public class LogWaitChecker
implements WaitChecker,
LogWaitCheckerCallback {
    private final String containerId;
    private final String logPattern;
    private final Logger log;
    private final CountDownLatch latch;
    private final LogGetHandle logHandle;

    public LogWaitChecker(String logPattern, DockerAccess dockerAccess, String containerId, Logger log) {
        this.containerId = containerId;
        this.logPattern = logPattern;
        this.log = log;
        this.latch = new CountDownLatch(1);
        this.logHandle = dockerAccess.getLogAsync(containerId, new LogMatchCallback(log, this, logPattern));
    }

    @Override
    public void matched() {
        this.latch.countDown();
        this.log.info("Pattern '%s' matched for container %s", this.logPattern, this.containerId);
    }

    @Override
    public boolean check() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public void cleanUp() {
        if (this.logHandle != null) {
            this.logHandle.finish();
        }
    }

    @Override
    public String getLogLabel() {
        return "on log out '" + this.logPattern + "'";
    }
}

