/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.chunked;

import com.google.gson.JsonObject;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.chunked.EntityStreamReaderUtil;
import io.fabric8.maven.docker.util.Logger;

public class PullOrPushResponseJsonHandler
implements EntityStreamReaderUtil.JsonEntityResponseHandler {
    private final Logger log;

    public PullOrPushResponseJsonHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void process(JsonObject json) throws DockerAccessException {
        if (json.has("progressDetail")) {
            this.log.progressUpdate(this.getStringOrEmpty(json, "id"), this.getStringOrEmpty(json, "status"), this.getStringOrEmpty(json, "progress"));
        } else if (json.has("error")) {
            this.throwDockerAccessException(json);
        } else {
            this.log.progressFinished();
            this.logInfoMessage(json);
            this.log.progressStart();
        }
    }

    private void logInfoMessage(JsonObject json) {
        String value = json.has("stream") ? json.get("stream").getAsString().replaceFirst("\n$", "") : (json.has("status") ? json.get("status").getAsString() : json.toString());
        this.log.info("%s", value);
    }

    private void throwDockerAccessException(JsonObject json) throws DockerAccessException {
        String msg = json.get("error").getAsString().trim();
        String details = json.getAsJsonObject("errorDetail").get("message").getAsString().trim();
        throw new DockerAccessException("%s %s", msg, msg.equals(details) ? "" : "(" + details + ")");
    }

    private String getStringOrEmpty(JsonObject json, String what) {
        return json.has(what) ? json.get(what).getAsString() : "";
    }

    @Override
    public void start() {
        this.log.progressStart();
    }

    @Override
    public void stop() {
        this.log.progressFinished();
    }
}

