/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;

public class MavenScmEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "f8-maven-scm";
    static final String SCM_CONNECTION = "fabric8.io/scm-con-url";
    static final String SCM_DEVELOPER_CONNECTION = "fabric8.io/scm-devcon-url";
    static final String SCM_TAG = "fabric8.io/scm-tag";
    static final String SCM_URL = "fabric8.io/scm-url";

    public MavenScmEnricher(EnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
    }

    public Map<String, String> getAnnotations(Kind kind) {
        MavenProject rootProject;
        HashMap<String, String> annotations = new HashMap<String, String>();
        if ((kind.isController() || kind == Kind.SERVICE) && this.hasScm(rootProject = this.getProject())) {
            Scm scm = rootProject.getScm();
            String connectionUrl = scm.getConnection();
            String devConnectionUrl = scm.getDeveloperConnection();
            String url = scm.getUrl();
            String tag = scm.getTag();
            if (StringUtils.isNotEmpty((CharSequence)connectionUrl)) {
                annotations.put(SCM_CONNECTION, connectionUrl);
            }
            if (StringUtils.isNotEmpty((CharSequence)devConnectionUrl)) {
                annotations.put(SCM_DEVELOPER_CONNECTION, devConnectionUrl);
            }
            if (StringUtils.isNotEmpty((CharSequence)tag)) {
                annotations.put(SCM_TAG, tag);
            }
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                annotations.put(SCM_URL, url);
            }
        }
        return annotations;
    }

    private boolean hasScm(MavenProject project) {
        return project.getScm() != null;
    }
}

