/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OpenShiftS2IEnricher
extends BaseEnricher {
    public OpenShiftS2IEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-openshift-s2i");
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        if (!this.hasImageConfiguration()) {
            this.log.verbose("No image configurations found, skipping ...", new Object[0]);
            return;
        }
        builder.accept((Visitor)new TypedVisitor<PodSpecBuilder>(){

            public void visit(PodSpecBuilder builder) {
                OpenShiftS2IEnricher.this.updatePodSpec(builder);
            }
        });
    }

    private void updatePodSpec(PodSpecBuilder builder) {
        if (this.isOpenShiftMode()) {
            this.log.debug("Now moving any docker environment variables from the image build configuration as in S2I binary mode!", new Object[0]);
            List containers = builder.getContainers();
            if (containers != null) {
                boolean updated = false;
                for (Container container : containers) {
                    Map env;
                    BuildImageConfiguration buildConfiguration;
                    String imageName = container.getImage();
                    ImageConfiguration image = this.getImage(imageName);
                    if (image == null || (buildConfiguration = image.getBuildConfiguration()) == null || (env = buildConfiguration.getEnv()) == null) continue;
                    for (Map.Entry entry : env.entrySet()) {
                        String name = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        ArrayList envVars = container.getEnv();
                        if (envVars == null) {
                            envVars = new ArrayList();
                        }
                        if (KubernetesResourceUtil.setEnvVar(envVars, (String)name, (String)value)) {
                            updated = true;
                            this.log.debug("Added to container " + imageName + " $" + name + "=" + value, new Object[0]);
                        }
                        container.setEnv(envVars);
                    }
                }
                if (updated) {
                    builder.withContainers(containers);
                }
            }
        }
    }

    private ImageConfiguration getImage(String imageName) {
        List images = this.getImages();
        for (ImageConfiguration imageConfiguration : images) {
            if (!Objects.equals(imageName, imageConfiguration.getName())) continue;
            return imageConfiguration;
        }
        this.log.warn("Could not find ImageConfiguration for image name: %s", new Object[]{imageName});
        return null;
    }
}

