/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.maven.core.util.MapUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.project.MavenProject;

public class ProjectEnricher
extends BaseEnricher {
    public ProjectEnricher(EnricherContext buildContext) {
        super(buildContext, "fmp-project");
    }

    public Map<String, String> getSelector(Kind kind) {
        return this.createLabels(kind == Kind.SERVICE || kind.isController() && !kind.isPodController());
    }

    public void adapt(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ObjectMetaBuilder>(){

            public void visit(ObjectMetaBuilder element) {
                Map labels = element.getLabels();
                MapUtil.mergeIfAbsent((Map)labels, (Map)ProjectEnricher.this.createLabels());
            }
        });
    }

    private Map<String, String> createLabels() {
        return this.createLabels(false);
    }

    private Map<String, String> createLabels(boolean withoutVersion) {
        MavenProject project = this.getProject();
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("project", project.getArtifactId());
        ret.put("group", project.getGroupId());
        ret.put("provider", "fabric8");
        if (!withoutVersion) {
            ret.put("version", project.getVersion());
        }
        return ret;
    }
}

