/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.util.InitContainerHandler;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class VolumePermissionEnricher
extends BaseEnricher {
    public static final String ENRICHER_NAME = "fmp-volume-permission";
    static final String VOLUME_STORAGE_CLASS_ANNOTATION = "volume.beta.kubernetes.io/storage-class";
    private final InitContainerHandler initContainerHandler;

    public VolumePermissionEnricher(EnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
        this.initContainerHandler = new InitContainerHandler(buildContext.getLog());
    }

    public void adapt(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<PodTemplateSpecBuilder>(){

            public void visit(PodTemplateSpecBuilder builder) {
                PodSpec podSpec = builder.buildSpec();
                if (podSpec == null) {
                    return;
                }
                if (!this.checkForPvc(podSpec)) {
                    return;
                }
                List containers = podSpec.getContainers();
                if (containers == null || containers.isEmpty()) {
                    return;
                }
                VolumePermissionEnricher.this.log.verbose("Adding init container for changing persistent volumes access mode to %s", new Object[]{VolumePermissionEnricher.this.getConfig(Config.permission)});
                if (!VolumePermissionEnricher.this.initContainerHandler.hasInitContainer(builder, VolumePermissionEnricher.ENRICHER_NAME)) {
                    VolumePermissionEnricher.this.initContainerHandler.appendInitContainer(builder, this.createPvInitContainer(podSpec));
                }
            }

            private boolean checkForPvc(PodSpec podSpec) {
                List volumes = podSpec.getVolumes();
                if (volumes != null) {
                    for (Volume volume : volumes) {
                        PersistentVolumeClaimVolumeSource persistentVolumeClaim = volume.getPersistentVolumeClaim();
                        if (persistentVolumeClaim == null) continue;
                        return true;
                    }
                }
                return false;
            }

            private JSONObject createPvInitContainer(PodSpec podSpec) {
                Map<String, String> mountPoints = this.extractMountPoints(podSpec);
                JSONObject entry = new JSONObject();
                entry.put("name", (Object)VolumePermissionEnricher.ENRICHER_NAME);
                entry.put("image", (Object)"busybox");
                entry.put("imagePullPolicy", (Object)"IfNotPresent");
                entry.put("command", (Object)this.createChmodCommandArray(mountPoints));
                entry.put("volumeMounts", (Object)this.createMounts(mountPoints));
                return entry;
            }

            private JSONArray createChmodCommandArray(Map<String, String> mountPoints) {
                JSONArray ret = new JSONArray();
                ret.put((Object)"chmod");
                ret.put((Object)VolumePermissionEnricher.this.getConfig(Config.permission));
                LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(mountPoints.values());
                for (String name : uniqueNames) {
                    ret.put((Object)name);
                }
                return ret;
            }

            private JSONArray createMounts(Map<String, String> mountPoints) {
                JSONArray ret = new JSONArray();
                for (Map.Entry<String, String> entry : mountPoints.entrySet()) {
                    JSONObject mount = new JSONObject();
                    mount.put("name", (Object)entry.getKey());
                    mount.put("mountPath", (Object)entry.getValue());
                    ret.put((Object)mount);
                }
                return ret;
            }

            private Map<String, String> extractMountPoints(PodSpec podSpec) {
                LinkedHashMap<String, String> nameToMount = new LinkedHashMap<String, String>();
                List volumes = podSpec.getVolumes();
                if (volumes != null) {
                    for (Volume volume : volumes) {
                        PersistentVolumeClaimVolumeSource persistentVolumeClaim = volume.getPersistentVolumeClaim();
                        if (persistentVolumeClaim == null) continue;
                        String name = volume.getName();
                        String mountPath = this.getMountPath(podSpec.getContainers(), name);
                        nameToMount.put(name, mountPath);
                    }
                }
                return nameToMount;
            }

            private String getMountPath(List<Container> containers, String name) {
                for (Container container : containers) {
                    List volumeMounts = container.getVolumeMounts();
                    if (volumeMounts == null) continue;
                    for (VolumeMount volumeMount : volumeMounts) {
                        if (!name.equals(volumeMount.getName())) continue;
                        return volumeMount.getMountPath();
                    }
                }
                throw new IllegalArgumentException("No matching volume mount found for volume " + name);
            }
        });
        builder.accept((Visitor)new TypedVisitor<PersistentVolumeClaimBuilder>(){

            public void visit(PersistentVolumeClaimBuilder pvcBuilder) {
                if (pvcBuilder.buildMetadata() == null) {
                    pvcBuilder.withNewMetadata().endMetadata();
                }
                if (!pvcBuilder.buildMetadata().getAnnotations().containsKey(VolumePermissionEnricher.VOLUME_STORAGE_CLASS_ANNOTATION)) {
                    ((PersistentVolumeClaimFluent.MetadataNested)pvcBuilder.editMetadata().addToAnnotations(VolumePermissionEnricher.VOLUME_STORAGE_CLASS_ANNOTATION, "standard")).endMetadata();
                }
            }
        });
    }

    static enum Config implements Configs.Key
    {
        permission{
            {
                this.d = "777";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

