/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.project.MavenProject;

public class MavenIssueManagementEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "f8-maven-issue-mgmt";
    static final String ISSUE_MANAGEMENT_SYSTEM = "fabric8.io/issue-system";
    static final String ISSUE_MANAGEMENT_URL = "fabric8.io/issue-tracker-url";

    public MavenIssueManagementEnricher(EnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
    }

    public Map<String, String> getAnnotations(Kind kind) {
        MavenProject rootProject;
        HashMap<String, String> annotations = new HashMap<String, String>();
        if ((kind.isController() || kind == Kind.SERVICE) && this.hasIssueManagement(rootProject = this.getProject())) {
            IssueManagement issueManagement = rootProject.getIssueManagement();
            String system = issueManagement.getSystem();
            String url = issueManagement.getUrl();
            if (StringUtils.isNotEmpty((CharSequence)system) && StringUtils.isNotEmpty((CharSequence)url)) {
                annotations.put(ISSUE_MANAGEMENT_SYSTEM, system);
                annotations.put(ISSUE_MANAGEMENT_URL, url);
                return annotations;
            }
        }
        return annotations;
    }

    private boolean hasIssueManagement(MavenProject project) {
        return project.getIssueManagement() != null;
    }
}

