/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.fabric8.AbstractHealthCheckEnricher;

public class QuarkusHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public QuarkusHealthCheckEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "f8-healthcheck-quarkus");
    }

    @Override
    protected Probe getReadinessProbe() {
        return this.discoverQuarkusHealthCheck(Configs.asInteger((String)this.getConfig(Config.readinessIntialDelay, "5")));
    }

    @Override
    protected Probe getLivenessProbe() {
        return this.discoverQuarkusHealthCheck(Configs.asInteger((String)this.getConfig(Config.livenessInitialDelay, "10")));
    }

    private Probe discoverQuarkusHealthCheck(int initialDelay) {
        if (!this.getContext().hasDependency("io.quarkus", "quarkus-smallrye-health")) {
            return null;
        }
        return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(Configs.asInteger((String)this.getConfig(Config.port)))).withPath(this.getConfig(Config.path))).withScheme(this.getConfig(Config.scheme))).endHttpGet()).withFailureThreshold(Configs.asInteger((String)this.getConfig(Config.failureThreshold)))).withSuccessThreshold(Configs.asInteger((String)this.getConfig(Config.successThreshold)))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
    }

    private static enum Config implements Configs.Key
    {
        scheme{
            {
                this.d = "HTTP";
            }
        }
        ,
        port{
            {
                this.d = "8080";
            }
        }
        ,
        failureThreshold{
            {
                this.d = "3";
            }
        }
        ,
        successThreshold{
            {
                this.d = "1";
            }
        }
        ,
        livenessInitialDelay,
        readinessIntialDelay,
        path{
            {
                this.d = "/health";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

