/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.ThorntailUtil;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.fabric8.AbstractHealthCheckEnricher;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Properties;

public class ThorntailV2HealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public static final String IO_THORNTAIL = "io.thorntail";

    public ThorntailV2HealthCheckEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "f8-healthcheck-thorntail-v2");
    }

    @Override
    protected Probe getReadinessProbe() {
        return this.discoverThorntailHealthCheck(10);
    }

    @Override
    protected Probe getLivenessProbe() {
        return this.discoverThorntailHealthCheck(180);
    }

    private Probe discoverThorntailHealthCheck(int initialDelay) {
        if (this.getContext().hasDependency(IO_THORNTAIL, "thorntail-kernel")) {
            return null;
        }
        if (this.getContext().hasDependency(IO_THORNTAIL, "monitor") || this.getContext().hasDependency(IO_THORNTAIL, "microprofile-health")) {
            Integer port = this.getPort();
            String scheme = this.getScheme().toUpperCase();
            String path = this.getPath();
            return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(port)).withPath(path)).withScheme(scheme)).endHttpGet()).withFailureThreshold(Integer.valueOf(this.getFailureThreshold()))).withSuccessThreshold(Integer.valueOf(this.getSuccessThreshold()))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
        }
        return null;
    }

    protected int getFailureThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.failureThreshold));
    }

    protected int getSuccessThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.successThreshold));
    }

    protected String getScheme() {
        return Configs.asString((String)this.getConfig(Config.scheme));
    }

    protected int getPort() {
        Properties properties = ThorntailUtil.getThorntailProperties((URLClassLoader)this.getContext().getProjectClassLoaders().getCompileClassLoader());
        properties.putAll((Map<?, ?>)System.getProperties());
        if (properties.containsKey("thorntail.http.port")) {
            return Integer.parseInt((String)properties.get("thorntail.http.port"));
        }
        return Configs.asInt((String)this.getConfig(Config.port));
    }

    protected String getPath() {
        return Configs.asString((String)this.getConfig(Config.path));
    }

    private static enum Config implements Configs.Key
    {
        scheme{
            {
                this.d = "HTTP";
            }
        }
        ,
        port{
            {
                this.d = "8080";
            }
        }
        ,
        failureThreshold{
            {
                this.d = "3";
            }
        }
        ,
        successThreshold{
            {
                this.d = "1";
            }
        }
        ,
        path{
            {
                this.d = "/health";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

