/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;

public class RevisionHistoryEnricher
extends BaseEnricher {
    public static final String DEFAULT_NAME = "fmp-revision-history";
    private static final String DEFAULT_NUMBER_OF_REVISIONS = "2";

    public RevisionHistoryEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, DEFAULT_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        final Integer maxRevisionHistories = Configs.asInt((String)this.getConfig(Config.limit));
        this.log.info("Adding revision history limit to %s", new Object[]{maxRevisionHistories});
        if (platformMode == PlatformMode.kubernetes) {
            builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

                public void visit(DeploymentBuilder item) {
                    ((DeploymentFluent.SpecNested)item.editOrNewSpec().withRevisionHistoryLimit(maxRevisionHistories)).endSpec();
                }
            });
        } else {
            builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

                public void visit(DeploymentConfigBuilder item) {
                    ((DeploymentConfigFluent.SpecNested)item.editOrNewSpec().withRevisionHistoryLimit(maxRevisionHistories)).endSpec();
                }
            });
        }
    }

    static enum Config implements Configs.Key
    {
        limit{
            {
                this.d = RevisionHistoryEnricher.DEFAULT_NUMBER_OF_REVISIONS;
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

