/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.watcher.api;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.PrefixedLogger;
import io.fabric8.maven.watcher.api.Watcher;
import io.fabric8.maven.watcher.api.WatcherConfig;
import io.fabric8.maven.watcher.api.WatcherContext;

public abstract class BaseWatcher
implements Watcher {
    private WatcherContext context;
    private WatcherConfig config;
    private String name;
    protected final PrefixedLogger log;

    public BaseWatcher(WatcherContext context, String name) {
        this.context = context;
        this.config = new WatcherConfig(context.getProject().getProperties(), name, context.getConfig());
        this.name = name;
        this.log = new PrefixedLogger(name, context.getLogger());
    }

    public WatcherContext getContext() {
        return this.context;
    }

    protected String getConfig(Configs.Key key) {
        return this.config.get(key);
    }

    protected String getConfig(Configs.Key key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }

    public String getName() {
        return this.name;
    }
}

