

                        
      
package io.fabric8.knative.client.eventing.v1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.v1.Trigger;
import io.fabric8.knative.eventing.v1.TriggerBuilder;
import io.fabric8.knative.eventing.v1.TriggerList;

import java.util.Map;
import java.util.TreeMap;


public class TriggerOperationsImpl extends HasMetadataOperation<Trigger, TriggerList, Resource<Trigger>> {

  public TriggerOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public TriggerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("eventing.knative.dev")
    .withApiGroupVersion("v1")
    .withPlural("triggers"));
    this.type = Trigger.class;
    this.listType = TriggerList.class;
  }

  public TriggerOperationsImpl newInstance(OperationContext context) {
    return new TriggerOperationsImpl(context);
  }

  @Override
  public Trigger edit(Visitor... visitors) {
    return patch(new TriggerBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
