

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1alpha1.internal.PrometheusSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.PrometheusSource;
import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.PrometheusSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PrometheusSourceHandler implements ResourceHandler<PrometheusSource, PrometheusSourceBuilder> {

  @Override
  public String getKind() {
    return PrometheusSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1alpha1";
      }

  @Override
  public PrometheusSource create(OkHttpClient client, Config config, String namespace, PrometheusSource item, boolean dryRun) {
    return new PrometheusSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public PrometheusSource replace(OkHttpClient client, Config config, String namespace, PrometheusSource item, boolean dryRun) {
    return new PrometheusSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public PrometheusSource reload(OkHttpClient client, Config config, String namespace, PrometheusSource item) {
    return new PrometheusSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PrometheusSourceBuilder edit(PrometheusSource item) {
    return new PrometheusSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, PrometheusSource item, boolean dryRun) {
    return new PrometheusSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PrometheusSource item, Watcher<PrometheusSource> watcher) {
    return new PrometheusSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PrometheusSource item, String resourceVersion, Watcher<PrometheusSource> watcher) {
    return new PrometheusSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PrometheusSource item, ListOptions listOptions, Watcher<PrometheusSource> watcher) {
    return new PrometheusSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public PrometheusSource waitUntilReady(OkHttpClient client, Config config, String namespace, PrometheusSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PrometheusSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PrometheusSource waitUntilCondition(OkHttpClient client, Config config, String namespace, PrometheusSource item, Predicate<PrometheusSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PrometheusSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
