

                        
      
package io.fabric8.knative.client.eventing.v1alpha1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabBinding;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabBindingBuilder;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabBindingList;

import java.util.Map;
import java.util.TreeMap;


public class GitLabBindingOperationsImpl extends HasMetadataOperation<GitLabBinding, GitLabBindingList, Resource<GitLabBinding>> {

  public GitLabBindingOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public GitLabBindingOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("bindings.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("gitlabbindings"));
    this.type = GitLabBinding.class;
    this.listType = GitLabBindingList.class;
  }

  public GitLabBindingOperationsImpl newInstance(OperationContext context) {
    return new GitLabBindingOperationsImpl(context);
  }

  @Override
  public GitLabBinding edit(Visitor... visitors) {
    return patch(new GitLabBindingBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
