

                        

package io.fabric8.knative.client.flows.v1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.flows.v1.internal.SequenceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.flows.v1.Sequence;
import io.fabric8.knative.flows.v1.SequenceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class SequenceHandler implements ResourceHandler<Sequence, SequenceBuilder> {

  @Override
  public String getKind() {
    return Sequence.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "eventing.knative.dev/v1";
      }

  @Override
  public Sequence create(OkHttpClient client, Config config, String namespace, Sequence item, boolean dryRun) {
    return new SequenceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Sequence replace(OkHttpClient client, Config config, String namespace, Sequence item, boolean dryRun) {
    return new SequenceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Sequence reload(OkHttpClient client, Config config, String namespace, Sequence item) {
    return new SequenceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public SequenceBuilder edit(Sequence item) {
    return new SequenceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Sequence item, boolean dryRun) {
    return new SequenceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Sequence item, Watcher<Sequence> watcher) {
    return new SequenceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Sequence item, String resourceVersion, Watcher<Sequence> watcher) {
    return new SequenceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Sequence item, ListOptions listOptions, Watcher<Sequence> watcher) {
    return new SequenceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public Sequence waitUntilReady(OkHttpClient client, Config config, String namespace, Sequence item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SequenceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Sequence waitUntilCondition(OkHttpClient client, Config config, String namespace, Sequence item, Predicate<Sequence> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SequenceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
