

                        
      
package io.fabric8.knative.client.serving.v1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.serving.v1.Route;
import io.fabric8.knative.serving.v1.RouteBuilder;
import io.fabric8.knative.serving.v1.RouteList;

import java.util.Map;
import java.util.TreeMap;


public class RouteOperationsImpl extends HasMetadataOperation<Route, RouteList, Resource<Route>> {

  public RouteOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public RouteOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("serving.knative.dev")
    .withApiGroupVersion("v1")
    .withPlural("routes"));
    this.type = Route.class;
    this.listType = RouteList.class;
  }

  public RouteOperationsImpl newInstance(OperationContext context) {
    return new RouteOperationsImpl(context);
  }

  @Override
  public Route edit(Visitor... visitors) {
    return patch(new RouteBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
