

                        

package io.fabric8.knative.client.sources.v1beta1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.sources.v1beta1.internal.ContainerSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.sources.v1beta1.ContainerSource;
import io.fabric8.knative.sources.v1beta1.ContainerSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ContainerSourceHandler implements ResourceHandler<ContainerSource, ContainerSourceBuilder> {

  @Override
  public String getKind() {
    return ContainerSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1beta1";
      }

  @Override
  public ContainerSource create(OkHttpClient client, Config config, String namespace, ContainerSource item, boolean dryRun) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ContainerSource replace(OkHttpClient client, Config config, String namespace, ContainerSource item, boolean dryRun) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ContainerSource reload(OkHttpClient client, Config config, String namespace, ContainerSource item) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ContainerSourceBuilder edit(ContainerSource item) {
    return new ContainerSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ContainerSource item, boolean dryRun) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ContainerSource item, Watcher<ContainerSource> watcher) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ContainerSource item, String resourceVersion, Watcher<ContainerSource> watcher) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ContainerSource item, ListOptions listOptions, Watcher<ContainerSource> watcher) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public ContainerSource waitUntilReady(OkHttpClient client, Config config, String namespace, ContainerSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ContainerSource waitUntilCondition(OkHttpClient client, Config config, String namespace, ContainerSource item, Predicate<ContainerSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
