

                        
      
package io.fabric8.knative.client.sources.v1beta1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.sources.v1beta1.PingSource;
import io.fabric8.knative.sources.v1beta1.PingSourceBuilder;
import io.fabric8.knative.sources.v1beta1.PingSourceList;

import java.util.Map;
import java.util.TreeMap;


public class PingSourceOperationsImpl extends HasMetadataOperation<PingSource, PingSourceList, Resource<PingSource>> {

  public PingSourceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PingSourceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("sources.knative.dev")
    .withApiGroupVersion("v1beta1")
    .withPlural("pingsources"));
    this.type = PingSource.class;
    this.listType = PingSourceList.class;
  }

  public PingSourceOperationsImpl newInstance(OperationContext context) {
    return new PingSourceOperationsImpl(context);
  }

  @Override
  public PingSource edit(Visitor... visitors) {
    return patch(new PingSourceBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
