/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientLoggableResource;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import java.net.URL;

public class PodOperationsImpl
extends HasMetadataOperation<KubernetesClient, Pod, PodList, DoneablePod, ClientLoggableResource<Pod, DoneablePod>>
implements ClientLoggableResource<Pod, DoneablePod> {
    public PodOperationsImpl(KubernetesClient client) {
        this(client, null, null, true, null);
    }

    public PodOperationsImpl(KubernetesClient client, String namespace, String name, Boolean cascading, Pod item) {
        super(client, "pods", namespace, name, cascading, item);
    }

    @Override
    public String getLog() {
        return this.getLog(true);
    }

    @Override
    public String getLog(Boolean isPretty) {
        return this.getLog(null, isPretty);
    }

    @Override
    public String getLog(String containerId) {
        return this.getLog(containerId, true);
    }

    @Override
    public String getLog(String containerId, Boolean isPretty) {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(isPretty);
        if (containerId != null && !containerId.isEmpty()) {
            sb.append("&container=").append(containerId);
        }
        try {
            URL url = new URL(this.getResourceUrl(), sb.toString());
            AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareGet(url.toString());
            ListenableFuture f = requestBuilder.execute();
            Response r = (Response)f.get();
            this.assertResponseCode(r, 200);
            return r.getResponseBody();
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }
}

