/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeleteable;
import io.fabric8.kubernetes.client.dsl.internal.Reaper;
import io.fabric8.kubernetes.client.dsl.internal.ReaperFactory;
import io.fabric8.kubernetes.client.dsl.internal.WatchImpl;
import io.fabric8.kubernetes.client.internal.Utils;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.AsyncHttpClient;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.ListenableFuture;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.Response;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.ws.DefaultWebSocketListener;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.ws.WebSocket;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.ws.WebSocketUpgradeHandler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseOperation<C extends KubernetesClient, T, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
implements ClientMixedOperation<C, T, L, D, R> {
    protected static final ObjectMapper mapper = new ObjectMapper();
    private final C client;
    private final String name;
    private final String namespace;
    private final String resourceT;
    private final Map<String, String> labels = new TreeMap<String, String>();
    private final Map<String, String> labelsNot = new TreeMap<String, String>();
    private final Map<String, String[]> labelsIn = new TreeMap<String, String[]>();
    private final Map<String, String[]> labelsNotIn = new TreeMap<String, String[]>();
    private final Map<String, String> fields = new TreeMap<String, String>();
    private final Class<T> clientType;
    private final Class<T> type;
    private final Class<L> listType;
    private final Class<D> doneableType;

    protected BaseOperation(C client, String resourceT, String namespace, String name) {
        this.client = client;
        this.namespace = namespace;
        this.name = name;
        this.resourceT = resourceT;
        this.clientType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        this.listType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[2];
        this.doneableType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[3];
    }

    protected BaseOperation(C client, String resourceT, String namespace, String name, Class<T> clientType, Class<T> type, Class<L> listType, Class<D> doneableType) {
        this.client = client;
        this.namespace = namespace;
        this.name = name;
        this.resourceT = resourceT;
        this.clientType = clientType;
        this.type = type;
        this.listType = listType;
        this.doneableType = doneableType;
    }

    @Override
    public T get() {
        try {
            URL requestUrl = this.getNamespacedUrl();
            if (this.name != null) {
                requestUrl = new URL(requestUrl, this.name);
            }
            return this.handleGet(requestUrl);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public D edit() throws KubernetesClientException {
        return this.edit(true);
    }

    @Override
    public D edit(boolean cascade) throws KubernetesClientException {
        throw new KubernetesClientException("Cannot edit read-only resources");
    }

    @Override
    public R withName(String name) {
        try {
            return (R)((ClientResource)this.getClass().getConstructor(this.clientType, String.class, String.class).newInstance(this.client, this.namespace, name));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ClientNonNamespaceOperation<C, T, L, D, R> inNamespace(String namespace) {
        try {
            return (ClientNonNamespaceOperation)this.getClass().getConstructor(this.clientType, String.class, String.class).newInstance(this.client, namespace, this.name);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public T create(T resource) throws KubernetesClientException {
        try {
            return this.handleCreate(resource);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public D createNew() throws KubernetesClientException {
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    BaseOperation.this.create(resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(Visitor.class).newInstance(visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public FilterWatchListDeleteable<T, L, Boolean> withLabels(Map<String, String> labels) {
        labels.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeleteable<T, L, Boolean> withoutLabels(Map<String, String> labels) throws KubernetesClientException {
        this.labelsNot.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeleteable<T, L, Boolean> withLabelIn(String key, String ... values) throws KubernetesClientException {
        this.labelsIn.put(key, values);
        return this;
    }

    @Override
    public FilterWatchListDeleteable<T, L, Boolean> withLabelNotIn(String key, String ... values) throws KubernetesClientException {
        this.labelsNotIn.put(key, values);
        return this;
    }

    @Override
    public FilterWatchListDeleteable<T, L, Boolean> withLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }

    @Override
    public FilterWatchListDeleteable<T, L, Boolean> withoutLabel(String key, String value) throws KubernetesClientException {
        this.labelsNot.put(key, value);
        return this;
    }

    @Override
    public FilterWatchListDeleteable<T, L, Boolean> withFields(Map<String, String> labels) {
        this.fields.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeleteable<T, L, Boolean> withField(String key, String value) {
        this.fields.put(key, value);
        return this;
    }

    @Override
    public L list() throws KubernetesClientException {
        try {
            ListenableFuture<Response> f;
            Response r;
            Iterator<Map.Entry<String, String>> iter;
            Map.Entry<String, String> entry2;
            URL requestUrl = this.getNamespacedUrl();
            AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareGet(requestUrl.toString());
            StringBuilder sb = new StringBuilder();
            if (this.labels != null && !this.labels.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                for (Map.Entry<String, String> entry2 : this.labels.entrySet()) {
                    sb.append(entry2.getKey()).append("=").append(entry2.getValue());
                }
            }
            if (this.labelsNot != null && !this.labelsNot.isEmpty()) {
                iter = this.labelsNot.entrySet().iterator();
                while (iter.hasNext()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    entry2 = iter.next();
                    sb.append(entry2.getKey()).append("!=").append(entry2.getValue());
                }
            }
            if (this.labelsIn != null && !this.labelsIn.isEmpty()) {
                iter = this.labelsIn.entrySet().iterator();
                while (iter.hasNext()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    entry2 = iter.next();
                    sb.append(entry2.getKey()).append(" in ").append("(").append(Utils.join((Object[])entry2.getValue())).append(")");
                }
            }
            if (this.labelsNotIn != null && !this.labelsNotIn.isEmpty()) {
                iter = this.labelsNotIn.entrySet().iterator();
                while (iter.hasNext()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    entry2 = iter.next();
                    sb.append(entry2.getKey()).append(" notin ").append("(").append(Utils.join((Object[])entry2.getValue())).append(")");
                }
            }
            if (sb.length() > 0) {
                requestBuilder.addQueryParam("labelSelector", sb.toString());
            }
            sb = new StringBuilder();
            if (this.fields != null && !this.fields.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                for (Map.Entry<String, String> entry2 : this.fields.entrySet()) {
                    sb.append(entry2.getKey()).append("=").append(entry2.getValue());
                }
            }
            if (sb.length() > 0) {
                requestBuilder.addQueryParam("fieldSelector", sb.toString());
            }
            if ((r = (Response)(f = requestBuilder.execute()).get()).getStatusCode() != 200) {
                Status status = (Status)mapper.reader(Status.class).readValue(r.getResponseBodyAsStream());
                throw new KubernetesClientException(status.getMessage(), status.getCode(), status);
            }
            return (L)((KubernetesResourceList)mapper.reader(this.listType).readValue(r.getResponseBodyAsStream()));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public Boolean delete() {
        return this.delete(true);
    }

    @Override
    public Boolean delete(boolean cascade) {
        if (this.name != null && !this.name.isEmpty()) {
            try {
                Reaper reaper;
                if (cascade && (reaper = ReaperFactory.getReaper(this)) != null) {
                    reaper.reap();
                }
                this.deleteThis();
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getCode() != 404) {
                    throw e;
                }
                return false;
            }
        }
        try {
            this.deleteList();
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return false;
        }
    }

    void deleteThis() throws KubernetesClientException {
        try {
            this.handleDelete(this.getResourceUrl());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    void deleteList() throws KubernetesClientException {
        try {
            L discoveredResources = this.list();
            for (Object resource : discoveredResources.getItems()) {
                HasMetadata metadataResource = (HasMetadata)resource;
                URL requestUrl = this.getRootUrl();
                if (metadataResource.getMetadata().getNamespace() != null) {
                    requestUrl = new URL(requestUrl, "namespaces/" + metadataResource.getMetadata().getNamespace() + "/");
                }
                requestUrl = new URL(requestUrl, this.getResourceT() + "/" + metadataResource.getMetadata().getName());
                AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareDelete(requestUrl.toString());
                ListenableFuture<Response> f = requestBuilder.execute();
                Response r = (Response)f.get();
                if (r.getStatusCode() == 200) continue;
                Status status = (Status)mapper.reader(Status.class).readValue(r.getResponseBodyAsStream());
                throw new KubernetesClientException(status.getMessage(), status.getCode(), status);
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public Watch watch(Watcher<T> watcher) throws KubernetesClientException {
        return this.watch(null, watcher);
    }

    @Override
    public Watch watch(String resourceVersion, final Watcher<T> watcher) throws KubernetesClientException {
        try {
            Map.Entry<String, String> entry;
            Iterator<Map.Entry<String, String>> iter;
            StringBuilder sb;
            if (resourceVersion == null) {
                L currentList = this.list();
                resourceVersion = currentList.getMetadata().getResourceVersion();
            }
            URL requestUrl = this.getNamespacedUrl();
            AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareGet(requestUrl.toString().replaceFirst("^http", "ws"));
            requestBuilder.addQueryParam("resourceVersion", resourceVersion);
            requestBuilder.addQueryParam("watch", "true");
            if (this.labels != null && !this.labels.isEmpty()) {
                sb = new StringBuilder();
                iter = this.labels.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    sb.append(entry.getKey()).append("=").append(entry.getValue());
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                }
                requestBuilder.addQueryParam("labelSelector", sb.toString());
            }
            if (this.fields != null && !this.fields.isEmpty()) {
                sb = new StringBuilder();
                iter = this.fields.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    sb.append(entry.getKey()).append("=").append(entry.getValue());
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                }
                requestBuilder.addQueryParam("fieldSelector", sb.toString());
            }
            ListenableFuture<WebSocket> f = requestBuilder.execute(new WebSocketUpgradeHandler.Builder().addWebSocketListener(new DefaultWebSocketListener(){
                private final Logger logger = LoggerFactory.getLogger(this.getClass());

                @Override
                public void onMessage(String message) {
                    try {
                        WatchEvent event = (WatchEvent)mapper.readerFor(WatchEvent.class).readValue(message);
                        HasMetadata obj = event.getObject();
                        Watcher.Action action = Watcher.Action.valueOf(event.getType());
                        watcher.eventReceived(action, obj);
                    }
                    catch (IOException e) {
                        this.logger.error("Could not deserialize watch event: {}", (Object)message, (Object)e);
                    }
                    catch (ClassCastException e) {
                        this.logger.error("Received wrong type of object for watch", (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error("Invalid event type", (Throwable)e);
                    }
                }
            }).build());
            return new WatchImpl((WebSocket)f.get());
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T update(T item) {
        return this.replace(item);
    }

    @Override
    public T update(T item, boolean cascade) {
        return this.replace(item, cascade);
    }

    @Override
    public T replace(T item) {
        return this.replace(item, true);
    }

    @Override
    public T replace(T item, boolean cascade) {
        throw new KubernetesClientException("Cannot update read-only resources");
    }

    protected URL getNamespacedUrl() throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.getNamespace() != null) {
            requestUrl = new URL(requestUrl, "namespaces/" + this.getNamespace() + "/");
        }
        requestUrl = new URL(requestUrl, this.resourceT + "/");
        return requestUrl;
    }

    protected URL getResourceUrl() throws MalformedURLException {
        return new URL(this.getNamespacedUrl(), this.name);
    }

    protected T handleResponse(AsyncHttpClient.BoundRequestBuilder requestBuilder, int successStatusCode) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        ListenableFuture<Response> f = requestBuilder.execute();
        Response r = (Response)f.get();
        if (r.getStatusCode() != successStatusCode) {
            Status status = (Status)mapper.reader(Status.class).readValue(r.getResponseBodyAsStream());
            throw new KubernetesClientException(status.getMessage(), status.getCode(), status);
        }
        return (T)mapper.reader(this.getType()).readValue(r.getResponseBodyAsStream());
    }

    protected void handleDelete(URL requestUrl) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareDelete(requestUrl.toString());
        ListenableFuture<Response> f = requestBuilder.execute();
        Response r = (Response)f.get();
        if (r.getStatusCode() != 200) {
            Status status = (Status)mapper.reader(Status.class).readValue(r.getResponseBodyAsStream());
            throw new KubernetesClientException(status.getMessage(), status.getCode(), status);
        }
    }

    protected T handleCreate(T resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().preparePost(this.getNamespacedUrl().toString());
        requestBuilder.setBody(mapper.writer().writeValueAsString(resource));
        return this.handleResponse(requestBuilder, 201);
    }

    protected T handleReplace(URL resourceUrl, T updated) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().preparePut(resourceUrl.toString());
        requestBuilder.setBody(mapper.writer().writeValueAsString(updated));
        return this.handleResponse(requestBuilder, 200);
    }

    protected T handleGet(URL resourceUrl) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareGet(resourceUrl.toString());
        return this.handleResponse(requestBuilder, 200);
    }

    public URL getRootUrl() {
        return this.client.getMasterUrl();
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<L> getListType() {
        return this.listType;
    }

    public Class<D> getDoneableType() {
        return this.doneableType;
    }

    @Override
    public C getClient() {
        return this.client;
    }
}

