/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import io.fabric8.kubernetes.client.internal.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    public static final String KUBERNETES_MASTER_SYSTEM_PROPERTY = "kubernetes.master";
    public static final String KUBERNETES_API_VERSION_SYSTEM_PROPERTY = "kubernetes.api.version";
    public static final String KUBERNETES_TLS_PROTOCOLS_SYSTEM_PROPERTY = "kubernetes.tls.protocols";
    public static final String KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY = "kubernetes.trust.certificates";
    public static final String KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY = "kubernetes.certs.ca.file";
    public static final String KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY = "kubernetes.certs.ca.data";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY = "kubernetes.certs.client.file";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY = "kubernetes.certs.client.data";
    public static final String KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY = "kubernetes.certs.client.key.file";
    public static final String KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY = "kubernetes.certs.client.key.data";
    public static final String KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY = "kubernetes.certs.client.key.algo";
    public static final String KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY = "kubernetes.certs.client.key.passphrase";
    public static final String KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY = "kubernetes.auth.basic.username";
    public static final String KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY = "kubernetes.auth.basic.password";
    public static final String KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY = "kubernetes.auth.tryKubeConfig";
    public static final String KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY = "kubernetes.auth.tryServiceAccount";
    public static final String KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY = "kubernetes.auth.token";
    public static final String KUBERNETES_WATCH_RECONNECT_INTERVAL_SYSTEM_PROPERTY = "kubernetes.watch.reconnectInterval";
    public static final String KUBERNETES_WATCH_RECONNECT_LIMIT_SYSTEM_PROPERTY = "kubernetes.watch.reconnectLimit";
    public static final String KUBERNETES_REQUEST_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.request.timeout";
    public static final String KUBERNETES_NAMESPACE_SYSTEM_PROPERTY = "kubernetes.namespace";
    public static final String KUBERNETES_KUBECONFIG_FILE = "kubeconfig";
    public static final String KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    public static final String KUBERNETES_HTTP_PROXY = "http.proxy";
    public static final String KUBERNETES_HTTPS_PROXY = "https.proxy";
    public static final String KUBERNETES_ALL_PROXY = "all.proxy";
    private Boolean trustCerts;
    private String masterUrl = Utils.getSystemPropertyOrEnvVar("kubernetes.master", "https://kubernetes.default.svc");
    private String apiVersion = Utils.getSystemPropertyOrEnvVar("kubernetes.api.version", "v1");
    private String namespace = Utils.getSystemPropertyOrEnvVar("kubernetes.namespace", "default");
    private String[] enabledProtocols = Utils.getSystemPropertyOrEnvVar("kubernetes.tls.protocols", "TLSv1.2").split(",");
    private String caCertFile = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.ca.file");
    private String caCertData = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.ca.data");
    private String clientCertFile = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.file");
    private String clientCertData = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.data");
    private String clientKeyFile = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.key.file");
    private String clientKeyData = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.key.data");
    private String clientKeyAlgo = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.key.algo", "RSA");
    private String clientKeyPassphrase = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.key.passphrase", "changeit");
    private String username = Utils.getSystemPropertyOrEnvVar("kubernetes.auth.basic.username");
    private String password = Utils.getSystemPropertyOrEnvVar("kubernetes.auth.basic.password");
    private String oauthToken = Utils.getSystemPropertyOrEnvVar("kubernetes.auth.token");
    private int watchReconnectInterval = Integer.parseInt(Utils.getSystemPropertyOrEnvVar("kubernetes.watch.reconnectInterval", "1000"));
    private int watchReconnectLimit = Integer.parseInt(Utils.getSystemPropertyOrEnvVar("kubernetes.watch.reconnectLimit", "-1"));
    private int requestTimeout = Integer.parseInt(Utils.getSystemPropertyOrEnvVar("kubernetes.request.timeout", "10000"));
    private String proxy = Utils.getSystemPropertyOrEnvVar("http.proxy", Utils.getSystemPropertyOrEnvVar("https.proxy", Utils.getSystemPropertyOrEnvVar("all.proxy")));
    private Map<Integer, String> errorMessages = new HashMap<Integer, String>();

    public Config() {
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY, true).booleanValue()) {
            this.tryServiceAccount();
        }
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY, true).booleanValue()) {
            this.tryKubeConfig();
        }
        this.trustCerts = Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY, Boolean.FALSE);
    }

    public Config(String masterUrl, String apiVersion, String namespace, String[] enabledProtocols, Boolean trustCerts, String caCertFile, String caCertData, String clientCertFile, String clientCertData, String clientKeyFile, String clientKeyData, String clientKeyAlgo, String clientKeyPassphrase, String username, String password, String oauthToken, int watchReconnectInterval, int watchReconnectLimit, int requestTimeout, String proxy) {
        this.masterUrl = masterUrl;
        this.apiVersion = apiVersion;
        this.namespace = namespace;
        this.enabledProtocols = enabledProtocols;
        this.trustCerts = trustCerts;
        this.caCertFile = caCertFile;
        this.caCertData = caCertData;
        this.clientCertFile = clientCertFile;
        this.clientCertData = clientCertData;
        this.clientKeyFile = clientKeyFile;
        this.clientKeyData = clientKeyData;
        this.clientKeyAlgo = clientKeyAlgo;
        this.clientKeyPassphrase = clientKeyPassphrase;
        this.username = username;
        this.password = password;
        this.oauthToken = oauthToken;
        this.watchReconnectInterval = watchReconnectInterval;
        this.watchReconnectLimit = watchReconnectLimit;
        this.requestTimeout = requestTimeout;
        this.proxy = proxy;
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY, true).booleanValue()) {
            this.tryServiceAccount();
        }
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY, true).booleanValue()) {
            this.tryKubeConfig();
        }
        this.trustCerts = this.trustCerts != null ? this.trustCerts : Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY, Boolean.FALSE);
    }

    private void tryServiceAccount() {
        boolean serviceAccountCaCertExists = Files.isRegularFile(Paths.get(KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH, new String[0]), new LinkOption[0]);
        if (serviceAccountCaCertExists) {
            this.caCertFile = this.caCertFile != null ? this.caCertFile : KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH;
        }
        try {
            String serviceTokenCandidate = new String(Files.readAllBytes(Paths.get(KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH, new String[0])));
            if ((this.oauthToken == null || this.oauthToken.isEmpty()) && serviceTokenCandidate != null) {
                this.oauthToken = serviceTokenCandidate;
                String txt = "Configured service account doesn't have access. Service account may have been revoked.";
                this.errorMessages.put(401, "Unauthorized! " + txt);
                this.errorMessages.put(403, "Forbidden!" + txt);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void tryKubeConfig() {
        String kubeConfigFile = Utils.getSystemPropertyOrEnvVar(KUBERNETES_KUBECONFIG_FILE, new File(System.getProperty("user.home", "."), ".kube" + File.separator + "config").toString());
        boolean kubeConfigFileExists = Files.isRegularFile(Paths.get(kubeConfigFile, new String[0]), new LinkOption[0]);
        if (kubeConfigFileExists) {
            try {
                io.fabric8.kubernetes.api.model.Config kubeConfig = KubeConfigUtils.parseConfig(new File(kubeConfigFile));
                Context currentContext = KubeConfigUtils.getCurrentContext(kubeConfig);
                Cluster currentCluster = KubeConfigUtils.getCluster(kubeConfig, currentContext);
                if (currentCluster != null) {
                    this.masterUrl = this.masterUrl != null ? this.masterUrl : currentCluster.getServer();
                    this.namespace = this.namespace != null ? this.namespace : currentContext.getNamespace();
                    this.caCertFile = this.caCertFile != null ? this.caCertFile : currentCluster.getCertificateAuthority();
                    String string = this.caCertData = this.caCertData != null ? this.caCertData : currentCluster.getCertificateAuthorityData();
                    this.trustCerts = this.trustCerts != null ? this.trustCerts : currentCluster.getInsecureSkipTlsVerify() != null && currentCluster.getInsecureSkipTlsVerify() != false;
                    AuthInfo currentAuthInfo = KubeConfigUtils.getUserAuthInfo(kubeConfig, currentContext);
                    if (currentAuthInfo != null) {
                        this.clientCertFile = this.clientCertFile != null ? this.clientCertFile : currentAuthInfo.getClientCertificate();
                        this.clientCertData = this.clientCertData != null ? this.clientCertData : currentAuthInfo.getClientCertificateData();
                        this.clientKeyFile = this.clientKeyFile != null ? this.clientKeyFile : currentAuthInfo.getClientKey();
                        this.clientKeyData = this.clientKeyData != null ? this.clientKeyData : currentAuthInfo.getClientKeyData();
                        this.oauthToken = this.oauthToken != null ? this.oauthToken : currentAuthInfo.getToken();
                        this.username = this.username != null ? this.username : currentAuthInfo.getUsername();
                        this.password = this.password != null ? this.password : currentAuthInfo.getPassword();
                        String txt = "Token may have expired! Please use kubectl login / oc login to log-in again.";
                        this.errorMessages.put(401, "Unauthorized! " + txt);
                        this.errorMessages.put(403, "Forbidden!" + txt);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Could not load kube config file from {}", (Object)kubeConfigFile, (Object)e);
            }
        }
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getClientKeyPassphrase() {
        return this.clientKeyPassphrase;
    }

    public void setClientKeyPassphrase(String clientKeyPassphrase) {
        this.clientKeyPassphrase = clientKeyPassphrase;
    }

    public String getClientKeyAlgo() {
        return this.clientKeyAlgo;
    }

    public void setClientKeyAlgo(String clientKeyAlgo) {
        this.clientKeyAlgo = clientKeyAlgo;
    }

    public String getClientKeyData() {
        return this.clientKeyData;
    }

    public void setClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
    }

    public String getClientKeyFile() {
        return this.clientKeyFile;
    }

    public void setClientKeyFile(String clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
    }

    public String getClientCertData() {
        return this.clientCertData;
    }

    public void setClientCertData(String clientCertData) {
        this.clientCertData = clientCertData;
    }

    public String getClientCertFile() {
        return this.clientCertFile;
    }

    public void setClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
    }

    public String getCaCertData() {
        return this.caCertData;
    }

    public void setCaCertData(String caCertData) {
        this.caCertData = caCertData;
    }

    public String getCaCertFile() {
        return this.caCertFile;
    }

    public void setCaCertFile(String caCertFile) {
        this.caCertFile = caCertFile;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public void setMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
    }

    public boolean isTrustCerts() {
        return this.trustCerts != null ? this.trustCerts : false;
    }

    public void setTrustCerts(boolean trustCerts) {
        this.trustCerts = trustCerts;
    }

    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    public void setWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
    }

    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    public void setWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
    }

    public Map<Integer, String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(Map<Integer, String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

