/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.DoneableEvent;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.EventListBuilder;
import io.fabric8.kubernetes.api.model.EventListFluent;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.mock.KubernetesMockServerTestBase;
import io.fabric8.kubernetes.server.mock.Returnable;
import io.fabric8.kubernetes.server.mock.Timeable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ErrorMessageTest
extends KubernetesMockServerTestBase {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void testCustomMessage() {
        this.expectedEx.expectMessage(CoreMatchers.startsWith((String)"Failure executing: DELETE"));
        this.expectedEx.expectMessage(CoreMatchers.containsString((String)"Message: MSG"));
        this.expectedEx.expectMessage(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Received status")));
        this.getClient().getConfiguration().getErrorMessages().put(403, "MSG");
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/events")).andReturn(200, ((EventListBuilder)((EventListFluent.ItemsNested)((EventFluent.MetadataNested)new EventListBuilder().addNewItem().withNewMetadata().withName("event1")).endMetadata()).endItem()).build())).once();
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/events/event1")).andReturn(403, Boolean.FALSE)).once();
        KubernetesClient client = this.getClient();
        ((ClientNonNamespaceOperation)client.events().inNamespace("test")).delete();
    }

    @Test
    public void testServerErrorWithStatus() {
        this.expectedEx.expectMessage(CoreMatchers.startsWith((String)"Failure executing: POST"));
        this.expectedEx.expectMessage(CoreMatchers.containsString((String)"Received status"));
        this.expectedEx.expectMessage(CoreMatchers.containsString((String)"Message: This operation"));
        ((Timeable)((Returnable)this.expect().withPath("/api/v1/namespaces/test/events")).andReturn(500, ((StatusBuilder)((StatusBuilder)((StatusBuilder)new StatusBuilder().withMessage("This operation is not allowed for some reason")).withReason("Some reason")).withCode(Integer.valueOf(500))).build())).once();
        KubernetesClient client = this.getClient();
        ((DoneableEvent)((EventFluent.MetadataNested)((DoneableEvent)((ClientNonNamespaceOperation)client.events().inNamespace("test")).createNew()).withNewMetadata().withName("event1")).endMetadata()).done();
    }
}

