/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Adapters;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.URL;

public abstract class BaseClient
implements Client {
    protected OkHttpClient httpClient;
    private URL masterUrl;
    private String apiVersion;
    private String namespace;
    private Config configuration;

    public BaseClient() throws KubernetesClientException {
        this(new ConfigBuilder().build());
    }

    public BaseClient(Config config) throws KubernetesClientException {
        this(HttpClientUtils.createHttpClient(config), config);
    }

    public BaseClient(final OkHttpClient httpClient, Config config) throws KubernetesClientException {
        try {
            this.httpClient = httpClient;
            this.namespace = config.getNamespace();
            this.configuration = config;
            this.apiVersion = config.getApiVersion();
            if (config.getMasterUrl() == null) {
                throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar("kubernetes.master") + "\"");
            }
            this.masterUrl = new URL(config.getMasterUrl());
            Adapters.register(new ExtensionAdapter<OkHttpClient>(){

                @Override
                public Class<OkHttpClient> getExtensionType() {
                    return OkHttpClient.class;
                }

                @Override
                public Boolean isAdaptable(Client client) {
                    return client instanceof BaseClient;
                }

                @Override
                public OkHttpClient adapt(Client client) {
                    return httpClient.clone();
                }
            });
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public BaseClient(String masterUrl) throws KubernetesClientException {
        this(((ConfigBuilder)new ConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    @Override
    public void close() {
        if (this.httpClient.getConnectionPool() != null) {
            this.httpClient.getConnectionPool().evictAll();
        }
        this.httpClient.getDispatcher().getExecutorService().shutdown();
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.isAdaptable(this);
        }
        return false;
    }

    @Override
    public <C> C adapt(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.adapt(this);
        }
        throw new IllegalStateException("No adapter available for type:" + type);
    }

    @Override
    public RootPaths rootPaths() {
        return new BaseOperation(this.httpClient, this.configuration, null, null, "", null, null, false, null, null, RootPaths.class, null, null){}.getRootPaths();
    }
}

