/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request;

import io.fabric8.kubernetes.client.internal.com.ning.http.client.AsyncHandler;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.AsyncHandlerExtensions;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.channel.ChannelManager;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.channel.Channels;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.future.NettyResponseFuture;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.future.StackTraceInspector;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.NettyRequestSender;
import io.fabric8.kubernetes.client.internal.com.ning.http.util.AsyncHttpProviderUtils;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.Channel;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelFuture;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelFutureListener;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.ssl.SslHandler;
import java.net.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyConnectListener<T>
implements ChannelFutureListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyConnectListener.class);
    private final NettyResponseFuture<T> future;
    private final NettyRequestSender requestSender;
    private final ChannelManager channelManager;
    private final boolean channelPreempted;
    private final Object partitionKey;

    public NettyConnectListener(NettyResponseFuture<T> future, NettyRequestSender requestSender, ChannelManager channelManager, boolean channelPreempted, Object partitionKey) {
        this.future = future;
        this.requestSender = requestSender;
        this.channelManager = channelManager;
        this.channelPreempted = channelPreempted;
        this.partitionKey = partitionKey;
    }

    public NettyResponseFuture<T> future() {
        return this.future;
    }

    private void abortChannelPreemption() {
        if (this.channelPreempted) {
            this.channelManager.abortChannelPreemption(this.partitionKey);
        }
    }

    private void writeRequest(Channel channel) {
        LOGGER.debug("Using non-cached Channel {} for {} '{}'", new Object[]{channel, this.future.getNettyRequest().getHttpRequest().getMethod(), this.future.getNettyRequest().getHttpRequest().getUri()});
        Channels.setAttribute(channel, this.future);
        if (this.future.isDone()) {
            this.abortChannelPreemption();
            return;
        }
        if (this.future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(this.future.getAsyncHandler())).onConnectionOpen();
        }
        this.channelManager.registerOpenChannel(channel, this.partitionKey);
        this.future.attachChannel(channel, false);
        this.requestSender.writeRequest(this.future, channel);
    }

    private void onFutureSuccess(final Channel channel) throws ConnectException {
        SslHandler sslHandler = channel.getPipeline().get(SslHandler.class);
        if (sslHandler != null) {
            sslHandler.handshake().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture handshakeFuture) throws Exception {
                    if (handshakeFuture.isSuccess()) {
                        AsyncHandler asyncHandler = NettyConnectListener.this.future.getAsyncHandler();
                        if (asyncHandler instanceof AsyncHandlerExtensions) {
                            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onSslHandshakeCompleted();
                        }
                        NettyConnectListener.this.writeRequest(channel);
                    } else {
                        NettyConnectListener.this.onFutureFailure(channel, handshakeFuture.getCause());
                    }
                }
            });
        } else {
            this.writeRequest(channel);
        }
    }

    private void onFutureFailure(Channel channel, Throwable cause) {
        this.abortChannelPreemption();
        boolean canRetry = this.future.canRetry();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to recover from failing to connect channel " + channel + " with a retry value of " + canRetry, cause);
        }
        if (canRetry && cause != null && (this.future.getState() != NettyResponseFuture.STATE.NEW || StackTraceInspector.recoverOnDisconnectException(cause)) && this.requestSender.retry(this.future)) {
            return;
        }
        LOGGER.debug("Failed to recover from connect exception: {} with channel {}", (Object)cause, (Object)channel);
        boolean printCause = cause != null && cause.getMessage() != null;
        String printedCause = printCause ? cause.getMessage() : AsyncHttpProviderUtils.getBaseUrl(this.future.getUri());
        ConnectException e = new ConnectException(printedCause);
        if (cause != null) {
            e.initCause(cause);
        }
        this.future.abort(e);
    }

    @Override
    public final void operationComplete(ChannelFuture f) throws Exception {
        Channel channel = f.getChannel();
        if (f.isSuccess()) {
            this.onFutureSuccess(channel);
        } else {
            this.onFutureFailure(channel, f.getCause());
        }
    }
}

