/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.com.ning.http.client.uri;

import io.fabric8.kubernetes.client.internal.com.ning.http.client.uri.Uri;

final class UriParser {
    public String scheme;
    public String host;
    public int port = -1;
    public String query;
    public String authority;
    public String path;
    public String userInfo;
    private int start;
    private int end = 0;
    private String urlWithoutQuery;

    UriParser() {
    }

    private void trimRight(String originalUrl) {
        this.end = originalUrl.length();
        while (this.end > 0 && originalUrl.charAt(this.end - 1) <= ' ') {
            --this.end;
        }
    }

    private void trimLeft(String originalUrl) {
        while (this.start < this.end && originalUrl.charAt(this.start) <= ' ') {
            ++this.start;
        }
        if (originalUrl.regionMatches(true, this.start, "url:", 0, 4)) {
            this.start += 4;
        }
    }

    private boolean isFragmentOnly(String originalUrl) {
        return this.start < originalUrl.length() && originalUrl.charAt(this.start) == '#';
    }

    private boolean isValidProtocolChar(char c) {
        return Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-';
    }

    private boolean isValidProtocolChars(String protocol) {
        for (int i = 1; i < protocol.length(); ++i) {
            if (this.isValidProtocolChar(protocol.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isValidProtocol(String protocol) {
        return protocol.length() > 0 && Character.isLetter(protocol.charAt(0)) && this.isValidProtocolChars(protocol);
    }

    private void computeInitialScheme(String originalUrl) {
        for (int i = this.start; i < this.end; ++i) {
            char c = originalUrl.charAt(i);
            if (c == ':') {
                String s = originalUrl.substring(this.start, i);
                if (!this.isValidProtocol(s)) break;
                this.scheme = s.toLowerCase();
                this.start = i + 1;
                break;
            }
            if (c == '/') break;
        }
    }

    private boolean overrideWithContext(Uri context, String originalUrl) {
        boolean isRelative = false;
        if (context != null && (this.scheme == null || this.scheme.equalsIgnoreCase(context.getScheme()))) {
            String contextPath = context.getPath();
            if (UriParser.isNotEmpty(contextPath) && contextPath.charAt(0) == '/') {
                this.scheme = null;
            }
            if (this.scheme == null) {
                this.scheme = context.getScheme();
                this.userInfo = context.getUserInfo();
                this.host = context.getHost();
                this.port = context.getPort();
                this.path = contextPath;
                isRelative = true;
            }
        }
        return isRelative;
    }

    private void computeFragment(String originalUrl) {
        int charpPosition = originalUrl.indexOf(35, this.start);
        if (charpPosition >= 0) {
            this.end = charpPosition;
        }
    }

    private void inheritContextQuery(Uri context, boolean isRelative) {
        if (isRelative && this.start == this.end) {
            this.query = context.getQuery();
        }
    }

    private boolean splitUrlAndQuery(String originalUrl) {
        boolean queryOnly = false;
        this.urlWithoutQuery = originalUrl;
        if (this.start < this.end) {
            int askPosition = originalUrl.indexOf(63);
            boolean bl = queryOnly = askPosition == this.start;
            if (askPosition != -1 && askPosition < this.end) {
                this.query = originalUrl.substring(askPosition + 1, this.end);
                if (this.end > askPosition) {
                    this.end = askPosition;
                }
                this.urlWithoutQuery = originalUrl.substring(0, askPosition);
            }
        }
        return queryOnly;
    }

    private boolean currentPositionStartsWith4Slashes() {
        return this.urlWithoutQuery.regionMatches(this.start, "////", 0, 4);
    }

    private boolean currentPositionStartsWith2Slashes() {
        return this.urlWithoutQuery.regionMatches(this.start, "//", 0, 2);
    }

    private void computeAuthority() {
        int authorityEndPosition = this.urlWithoutQuery.indexOf(47, this.start);
        if (authorityEndPosition < 0 && (authorityEndPosition = this.urlWithoutQuery.indexOf(63, this.start)) < 0) {
            authorityEndPosition = this.end;
        }
        this.host = this.authority = this.urlWithoutQuery.substring(this.start, authorityEndPosition);
        this.start = authorityEndPosition;
    }

    private void computeUserInfo() {
        int atPosition = this.authority.indexOf(64);
        if (atPosition != -1) {
            this.userInfo = this.authority.substring(0, atPosition);
            this.host = this.authority.substring(atPosition + 1);
        } else {
            this.userInfo = null;
        }
    }

    private boolean isMaybeIPV6() {
        return this.host.length() > 0 && this.host.charAt(0) == '[';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeIPV6() {
        int positionAfterClosingSquareBrace = this.host.indexOf(93) + 1;
        if (positionAfterClosingSquareBrace <= 1) throw new IllegalArgumentException("Invalid authority field: " + this.authority);
        this.port = -1;
        if (this.host.length() > positionAfterClosingSquareBrace) {
            if (this.host.charAt(positionAfterClosingSquareBrace) != ':') throw new IllegalArgumentException("Invalid authority field: " + this.authority);
            int portPosition = positionAfterClosingSquareBrace + 1;
            if (this.host.length() > portPosition) {
                this.port = Integer.parseInt(this.host.substring(portPosition));
            }
        }
        this.host = this.host.substring(0, positionAfterClosingSquareBrace);
    }

    private void computeRegularHostPort() {
        int colonPosition = this.host.indexOf(58);
        this.port = -1;
        if (colonPosition >= 0) {
            int portPosition = colonPosition + 1;
            if (this.host.length() > portPosition) {
                this.port = Integer.parseInt(this.host.substring(portPosition));
            }
            this.host = this.host.substring(0, colonPosition);
        }
    }

    private void removeEmbeddedDot() {
        this.path = this.path.replace("/./", "/");
    }

    private void removeEmbedded2Dots() {
        int i = 0;
        while ((i = this.path.indexOf("/../", i)) >= 0) {
            if (i > 0) {
                this.end = this.path.lastIndexOf(47, i - 1);
                if (this.end >= 0 && this.path.indexOf("/../", this.end) != 0) {
                    this.path = this.path.substring(0, this.end) + this.path.substring(i + 3);
                    i = 0;
                    continue;
                }
                if (this.end != 0) continue;
                break;
            }
            i += 3;
        }
    }

    private void removeTailing2Dots() {
        while (this.path.endsWith("/..")) {
            this.end = this.path.lastIndexOf(47, this.path.length() - 4);
            if (this.end < 0) break;
            this.path = this.path.substring(0, this.end + 1);
        }
    }

    private void removeStartingDot() {
        if (this.path.startsWith("./") && this.path.length() > 2) {
            this.path = this.path.substring(2);
        }
    }

    private void removeTrailingDot() {
        if (this.path.endsWith("/.")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    private void initRelativePath() {
        int lastSlashPosition = this.path.lastIndexOf(47);
        String pathEnd = this.urlWithoutQuery.substring(this.start, this.end);
        this.path = lastSlashPosition == -1 ? (this.authority != null ? "/" + pathEnd : pathEnd) : this.path.substring(0, lastSlashPosition + 1) + pathEnd;
    }

    private void handlePathDots() {
        if (this.path.indexOf(46) != -1) {
            this.removeEmbeddedDot();
            this.removeEmbedded2Dots();
            this.removeTailing2Dots();
            this.removeStartingDot();
            this.removeTrailingDot();
        }
    }

    private void parseAuthority() {
        if (!this.currentPositionStartsWith4Slashes() && this.currentPositionStartsWith2Slashes()) {
            this.start += 2;
            this.computeAuthority();
            this.computeUserInfo();
            if (this.host != null) {
                if (this.isMaybeIPV6()) {
                    this.computeIPV6();
                } else {
                    this.computeRegularHostPort();
                }
            }
            if (this.port < -1) {
                throw new IllegalArgumentException("Invalid port number :" + this.port);
            }
            if (UriParser.isNotEmpty(this.authority)) {
                this.path = "";
            }
        }
    }

    private void handleRelativePath() {
        this.initRelativePath();
        this.handlePathDots();
    }

    private void computeRegularPath() {
        if (this.urlWithoutQuery.charAt(this.start) == '/') {
            this.path = this.urlWithoutQuery.substring(this.start, this.end);
        } else if (UriParser.isNotEmpty(this.path)) {
            this.handleRelativePath();
        } else {
            String pathEnd = this.urlWithoutQuery.substring(this.start, this.end);
            this.path = this.authority != null ? "/" + pathEnd : pathEnd;
        }
    }

    private void computeQueryOnlyPath() {
        int lastSlashPosition = this.path.lastIndexOf(47);
        this.path = lastSlashPosition < 0 ? "/" : this.path.substring(0, lastSlashPosition) + "/";
    }

    private void computePath(boolean queryOnly) {
        if (this.start < this.end) {
            this.computeRegularPath();
        } else if (queryOnly && this.path != null) {
            this.computeQueryOnlyPath();
        } else if (this.path == null) {
            this.path = "";
        }
    }

    public void parse(Uri context, String originalUrl) {
        if (originalUrl == null) {
            throw new NullPointerException("originalUrl");
        }
        boolean isRelative = false;
        this.trimRight(originalUrl);
        this.trimLeft(originalUrl);
        if (!this.isFragmentOnly(originalUrl)) {
            this.computeInitialScheme(originalUrl);
        }
        this.overrideWithContext(context, originalUrl);
        this.computeFragment(originalUrl);
        this.inheritContextQuery(context, isRelative);
        boolean queryOnly = this.splitUrlAndQuery(originalUrl);
        this.parseAuthority();
        this.computePath(queryOnly);
    }

    private static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }
}

