/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatus;

public class SerializationUtils {
    private static ObjectMapper mapper;
    private static ObjectMapper statelessMapper;

    public static ObjectMapper getStatelessMapper() {
        if (statelessMapper == null) {
            statelessMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            statelessMapper.addMixIn(ObjectMeta.class, ObjectMetaMixIn.class);
            statelessMapper.addMixIn(ReplicationController.class, StatelessReplicationControllerMixIn.class);
        }
        return statelessMapper;
    }

    public static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        }
        return mapper;
    }

    public static String dumpAsYaml(HasMetadata obj) throws JsonProcessingException {
        return SerializationUtils.getMapper().writeValueAsString((Object)obj);
    }

    public static String dumpWithoutRuntimeStateAsYaml(HasMetadata obj) throws JsonProcessingException {
        return SerializationUtils.getStatelessMapper().writeValueAsString((Object)obj);
    }

    abstract class StatelessReplicationControllerMixIn
    extends ReplicationController {
        @JsonIgnore
        private ReplicationControllerStatus status;

        StatelessReplicationControllerMixIn() {
        }

        @JsonIgnore
        public abstract ReplicationControllerStatus getStatus();
    }

    abstract class ObjectMetaMixIn
    extends ObjectMeta {
        @JsonIgnore
        private String creationTimestamp;
        @JsonIgnore
        private String deletionTimestamp;
        @JsonIgnore
        private Long generation;
        @JsonIgnore
        private String resourceVersion;
        @JsonIgnore
        private String selfLink;
        @JsonIgnore
        private String uid;

        ObjectMetaMixIn() {
        }

        @JsonIgnore
        public abstract String getCreationTimestamp();

        @JsonIgnore
        public abstract String getDeletionTimestamp();

        @JsonIgnore
        public abstract Long getGeneration();

        @JsonIgnore
        public abstract String getResourceVersion();

        @JsonIgnore
        public abstract String getSelfLink();

        @JsonIgnore
        public abstract String getUid();
    }
}

