/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.com.ning.http.util;

import io.fabric8.kubernetes.client.internal.com.ning.http.client.ProxyServer;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.Realm;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.uri.Uri;
import io.fabric8.kubernetes.client.internal.com.ning.http.util.AsyncHttpProviderUtils;
import io.fabric8.kubernetes.client.internal.com.ning.http.util.Base64;
import io.fabric8.kubernetes.client.internal.com.ning.http.util.MiscUtils;
import io.fabric8.kubernetes.client.internal.com.ning.http.util.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class AuthenticatorUtils {
    public static String computeBasicAuthentication(Realm realm) {
        return AuthenticatorUtils.computeBasicAuthentication(realm.getPrincipal(), realm.getPassword(), realm.getCharset());
    }

    public static String computeBasicAuthentication(ProxyServer proxyServer) {
        return AuthenticatorUtils.computeBasicAuthentication(proxyServer.getPrincipal(), proxyServer.getPassword(), proxyServer.getCharset());
    }

    private static String computeBasicAuthentication(String principal, String password, Charset charset) {
        String s = principal + ":" + password;
        return "Basic " + Base64.encode(s.getBytes(charset));
    }

    public static String computeRealmURI(Realm realm) {
        return AuthenticatorUtils.computeRealmURI(realm.getUri(), realm.isUseAbsoluteURI(), realm.isOmitQuery());
    }

    public static String computeRealmURI(Uri uri, boolean useAbsoluteURI, boolean omitQuery) {
        if (useAbsoluteURI) {
            return omitQuery && MiscUtils.isNonEmpty(uri.getQuery()) ? uri.withNewQuery(null).toUrl() : uri.toUrl();
        }
        String path = AsyncHttpProviderUtils.getNonEmptyPath(uri);
        return omitQuery || !MiscUtils.isNonEmpty(uri.getQuery()) ? path : path + "?" + uri.getQuery();
    }

    public static String computeDigestAuthentication(Realm realm) {
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.append(builder, "username", realm.getPrincipal(), true);
        AuthenticatorUtils.append(builder, "realm", realm.getRealmName(), true);
        AuthenticatorUtils.append(builder, "nonce", realm.getNonce(), true);
        AuthenticatorUtils.append(builder, "uri", AuthenticatorUtils.computeRealmURI(realm), true);
        if (MiscUtils.isNonEmpty(realm.getAlgorithm())) {
            AuthenticatorUtils.append(builder, "algorithm", realm.getAlgorithm(), false);
        }
        AuthenticatorUtils.append(builder, "response", realm.getResponse(), true);
        if (realm.getOpaque() != null) {
            AuthenticatorUtils.append(builder, "opaque", realm.getOpaque(), true);
        }
        if (realm.getQop() != null) {
            AuthenticatorUtils.append(builder, "qop", realm.getQop(), false);
            AuthenticatorUtils.append(builder, "nc", realm.getNc(), false);
            AuthenticatorUtils.append(builder, "cnonce", realm.getCnonce(), true);
        }
        builder.setLength(builder.length() - 2);
        return new String(StringUtils.charSequence2Bytes(builder, StandardCharsets.ISO_8859_1));
    }

    private static StringBuilder append(StringBuilder builder, String name, String value, boolean quoted) {
        builder.append(name).append('=');
        if (quoted) {
            builder.append('\"').append(value).append('\"');
        } else {
            builder.append(value);
        }
        return builder.append(", ");
    }
}

