/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.org.jboss.netty.bootstrap;

import io.fabric8.kubernetes.client.internal.org.jboss.netty.bootstrap.Bootstrap;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.Channel;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelFactory;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelFuture;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelPipeline;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelPipelineException;
import java.net.SocketAddress;

public class ClientBootstrap
extends Bootstrap {
    public ClientBootstrap() {
    }

    public ClientBootstrap(ChannelFactory channelFactory) {
        super(channelFactory);
    }

    public ChannelFuture connect() {
        SocketAddress remoteAddress = (SocketAddress)this.getOption("remoteAddress");
        if (remoteAddress == null) {
            throw new IllegalStateException("remoteAddress option is not set.");
        }
        return this.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        return this.connect(remoteAddress, localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        Channel ch;
        block7: {
            ChannelPipeline pipeline;
            if (remoteAddress == null) {
                throw new NullPointerException("remoteAddress");
            }
            try {
                pipeline = this.getPipelineFactory().getPipeline();
            }
            catch (Exception e) {
                throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
            }
            ch = this.getFactory().newChannel(pipeline);
            boolean success = false;
            try {
                ch.getConfig().setOptions(this.getOptions());
                success = true;
                Object var7_7 = null;
                if (success) break block7;
                ch.close();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (!success) {
                    ch.close();
                }
                throw throwable;
            }
            {
            }
        }
        if (localAddress != null) {
            ch.bind(localAddress);
        }
        return ch.connect(remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture bind(SocketAddress localAddress) {
        Channel ch;
        block6: {
            ChannelPipeline pipeline;
            if (localAddress == null) {
                throw new NullPointerException("localAddress");
            }
            try {
                pipeline = this.getPipelineFactory().getPipeline();
            }
            catch (Exception e) {
                throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
            }
            ch = this.getFactory().newChannel(pipeline);
            boolean success = false;
            try {
                ch.getConfig().setOptions(this.getOptions());
                success = true;
                Object var6_6 = null;
                if (success) break block6;
                ch.close();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!success) {
                    ch.close();
                }
                throw throwable;
            }
            {
            }
        }
        return ch.bind(localAddress);
    }
}

