/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.EditableReplicationController;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.EditReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.ReplicationControllerOperationsImpl;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RollingUpdater<C extends Client> {
    static final String DEPLOYMENT_KEY = "deployment";
    private static final Long DEFAULT_ROLLING_TIMEOUT = 900000L;
    private static final transient Logger LOG = LoggerFactory.getLogger(RollingUpdater.class);
    private final OkHttpClient client;
    private final Config config;
    private final String namespace;
    private final long rollingTimeoutMillis;
    private final long loggingIntervalMillis;

    RollingUpdater(OkHttpClient client, Config config, String namespace) {
        this(client, config, namespace, DEFAULT_ROLLING_TIMEOUT, 20000L);
    }

    RollingUpdater(OkHttpClient client, Config config, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        this.client = client;
        this.config = config;
        this.namespace = namespace;
        this.rollingTimeoutMillis = rollingTimeoutMillis;
        this.loggingIntervalMillis = loggingIntervalMillis;
    }

    ReplicationController rollUpdate(ReplicationController oldRC, ReplicationController newRC) {
        try {
            String namespace = oldRC.getMetadata().getNamespace();
            String oldRCName = oldRC.getMetadata().getName();
            String oldDeploymentHash = this.md5sum((HasMetadata)oldRC);
            PodList oldRCPods = (PodList)((FilterWatchListDeletable)((ClientNonNamespaceOperation)this.pods().inNamespace(namespace)).withLabels(oldRC.getSpec().getSelector())).list();
            for (Pod pod : oldRCPods.getItems()) {
                pod.getMetadata().getLabels().put(DEPLOYMENT_KEY, oldDeploymentHash);
                try {
                    ((ClientPodResource)((ClientNonNamespaceOperation)this.pods().inNamespace(namespace)).withName(pod.getMetadata().getName())).replace(pod);
                }
                catch (KubernetesClientException e) {
                    LOG.warn("Unable to add deployment key to pod: {}", (Object)e.getMessage());
                }
            }
            oldRC.getSpec().getSelector().put(DEPLOYMENT_KEY, oldDeploymentHash);
            oldRC.getSpec().getTemplate().getMetadata().getLabels().put(DEPLOYMENT_KEY, oldDeploymentHash);
            ((EditReplaceDeletable)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(oldRCName)).cascading(false)).replace(oldRC);
            String newDeploymentHash = this.md5sum((HasMetadata)newRC);
            String newRCName = newRC.getMetadata().getName();
            if (newRCName == null || newRCName.equals(oldRC.getMetadata().getName())) {
                newRCName = newRCName + "-" + newDeploymentHash;
            }
            EditableReplicationController clonedRC = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder(newRC).editMetadata().withResourceVersion(null)).withName(newRCName)).endMetadata()).editSpec().withReplicas(Integer.valueOf(0))).addToSelector(DEPLOYMENT_KEY, newDeploymentHash)).editTemplate().editMetadata().addToLabels(DEPLOYMENT_KEY, newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
            ReplicationController createdRC = (ReplicationController)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).create(clonedRC);
            int oldReplicas = oldRC.getSpec().getReplicas();
            while (createdRC.getSpec().getReplicas() < newRC.getSpec().getReplicas()) {
                int newReplicas = createdRC.getSpec().getReplicas() + 1;
                ((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(createdRC.getMetadata().getName())).scale(newReplicas, true);
                this.waitUntilPodsAreReady(createdRC, namespace, newReplicas);
                createdRC.getSpec().setReplicas(Integer.valueOf(newReplicas));
                if (oldReplicas <= 0) continue;
                ((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(oldRCName)).scale(--oldReplicas, true);
                this.waitUntilPodsAreReady(oldRC, namespace, oldReplicas);
            }
            ((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(oldRCName)).delete();
            if (Objects.equals(oldRCName, newRC.getMetadata().getName())) {
                createdRC.getMetadata().setResourceVersion(null);
                createdRC.getMetadata().setName(oldRCName);
                createdRC = (ReplicationController)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).create(createdRC);
                ((EditReplaceDeletable)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(newRCName)).cascading(false)).delete();
                Map createdRCSelector = createdRC.getSpec().getSelector();
                createdRCSelector.remove(DEPLOYMENT_KEY);
                createdRC.getSpec().getTemplate().getMetadata().getLabels().remove(DEPLOYMENT_KEY);
                createdRC = (ReplicationController)((EditReplaceDeletable)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.replicationControllers().inNamespace(namespace)).withName(createdRC.getMetadata().getName())).cascading(false)).replace(createdRC);
            }
            return createdRC;
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new KubernetesClientException("Could not calculate MD5 of RC", e);
        }
    }

    private void waitUntilPodsAreReady(final ReplicationController rc, final String namespace, final int requiredPodCount) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicInteger podCount = new AtomicInteger(0);
        Runnable readyPodsPoller = new Runnable(){

            @Override
            public void run() {
                PodList podList = (PodList)((FilterWatchListDeletable)((ClientNonNamespaceOperation)RollingUpdater.this.pods().inNamespace(namespace)).withLabels(rc.getSpec().getSelector())).list();
                int count = 0;
                List items = podList.getItems();
                for (Pod item : items) {
                    for (PodCondition c : item.getStatus().getConditions()) {
                        if (!c.getType().equals("Ready") || !c.getStatus().equals("True")) continue;
                        ++count;
                    }
                }
                podCount.set(count);
                if (count == requiredPodCount) {
                    countDownLatch.countDown();
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(readyPodsPoller, 0L, 1L, TimeUnit.SECONDS);
        ScheduledFuture<?> logger = executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                LOG.debug("Only {}/{} pod(s) ready for ReplicationController: {} in namespace: {} seconds so waiting...", new Object[]{podCount.get(), requiredPodCount, rc.getMetadata().getName(), namespace});
            }
        }, 0L, this.loggingIntervalMillis, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(this.rollingTimeoutMillis, TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            poller.cancel(true);
            logger.cancel(true);
            executor.shutdown();
            LOG.warn("Only {}/{} pod(s) ready for ReplicationController: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{podCount.get(), requiredPodCount, rc.getMetadata().getName(), namespace, TimeUnit.MILLISECONDS.toSeconds(this.rollingTimeoutMillis)});
        }
    }

    private String md5sum(HasMetadata obj) throws NoSuchAlgorithmException, JsonProcessingException {
        byte[] digest = MessageDigest.getInstance("MD5").digest(SerializationUtils.dumpWithoutRuntimeStateAsYaml(obj).getBytes());
        BigInteger i = new BigInteger(1, digest);
        return String.format("%1$032x", i);
    }

    private ClientOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl(this.client, this.config, this.namespace);
    }

    private ClientOperation<Pod, PodList, DoneablePod, ClientPodResource<Pod, DoneablePod>> pods() {
        return new PodOperationsImpl(this.client, this.config, this.namespace);
    }
}

