/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.client.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void existingSysPropShouldReturnValue() {
        System.setProperty("something", "value");
        Assert.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"something"));
        System.getProperties().remove("something");
    }

    @Test
    public void missingSysPropAndEnvVarShouldReturnNull() {
        Assert.assertNull((Object)Utils.getSystemPropertyOrEnvVar((String)"doesn't exist"));
    }

    @Test
    public void existingEnvVarShouldReturnValue() {
        Assert.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"ENV_VAR_EXISTS"));
    }

    @Test
    public void existingEnvVarShouldReturnValueFromConvertedSysPropName() {
        Assert.assertEquals((Object)"value", (Object)Utils.getSystemPropertyOrEnvVar((String)"env.var.exists"));
    }

    @Test
    public void existingEnvVarShouldReturnBooleanValueFromConvertedSysPropName() {
        Assert.assertEquals((Object)true, (Object)Utils.getSystemPropertyOrEnvVar((String)"env.var.exists.boolean", (Boolean)false));
    }

    @Test
    public void missingEnvVarShouldReturnDefaultValue() {
        Assert.assertEquals((Object)true, (Object)Utils.getSystemPropertyOrEnvVar((String)"DONT_EXIST", (Boolean)true));
    }
}

