/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.server.mock;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.server.mock.KubernetesMockServer;
import java.io.IOException;
import okhttp3.TlsVersion;
import org.junit.Assert;
import org.junit.Test;

public class MasterProtocolTest {
    @Test
    public void testWithSSL() throws IOException {
        KubernetesMockServer sslServer = new KubernetesMockServer();
        sslServer.init();
        String host = sslServer.getHostName();
        Integer port = sslServer.getPort();
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(host + ":" + port)).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_0})).withTrustCerts(true)).build();
        Assert.assertTrue((boolean)config.getMasterUrl().toLowerCase().startsWith("https://"));
        sslServer.destroy();
    }

    @Test
    public void testWithoutSSL() throws IOException {
        KubernetesMockServer plainServer = new KubernetesMockServer(false);
        plainServer.init();
        String host = plainServer.getHostName();
        Integer port = plainServer.getPort();
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(host + ":" + port)).build();
        Assert.assertTrue((boolean)config.getMasterUrl().toLowerCase().startsWith("http://"));
        plainServer.destroy();
    }
}

