/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.api.model.WatchEventBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.WatchTest;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.kubernetes.server.mock.KubernetesServer;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOrOnceable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchOverHTTP {
    static final Pod pod1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withNamespace("test")).withName("pod1")).withResourceVersion("1")).endMetadata()).build();
    static final Status outdatedStatus = ((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(410))).withMessage("401: The event in requested index is outdated and cleared (the requested history has been cleared [3/1]) [2]")).build();
    static final WatchEvent outdatedEvent = ((WatchEventBuilder)new WatchEventBuilder().withStatusObject(outdatedStatus)).build();
    final String path = "/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true";
    @Rule
    public KubernetesServer server = new KubernetesServer(false);
    Logger logger = LoggerFactory.getLogger(WatchTest.class);

    @Test
    public void testDeleted() throws InterruptedException {
        this.logger.info("testDeleted");
        KubernetesClient client = (KubernetesClient)this.server.getClient().inNamespace("test");
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.server.expect().withPath("/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true")).andReturn(200, (Object)"Failed WebSocket Connection")).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.server.expect().withPath("/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true")).andReturnChunked(200, new Object[]{new WatchEvent((KubernetesResource)pod1, "DELETED"), "\n", new WatchEvent((KubernetesResource)pod1, "ADDED"), "\n"})).once();
        final CountDownLatch addLatch = new CountDownLatch(1);
        final CountDownLatch deleteLatch = new CountDownLatch(1);
        try (Watch watch = (Watch)((Watchable)((PodResource)client.pods().withName("pod1")).withResourceVersion("1")).watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod resource) {
                switch (action) {
                    case DELETED: {
                        deleteLatch.countDown();
                        break;
                    }
                    case ADDED: {
                        addLatch.countDown();
                        break;
                    }
                    default: {
                        throw new AssertionFailedError();
                    }
                }
            }

            public void onClose(KubernetesClientException cause) {
            }
        });){
            Assert.assertTrue((boolean)addLatch.await(10L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)deleteLatch.await(10L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testOutdated() throws InterruptedException {
        this.logger.info("testOutdated");
        KubernetesClient client = (KubernetesClient)this.server.getClient().inNamespace("test");
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.server.expect().withPath("/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true")).andReturn(200, (Object)"Failed WebSocket Connection")).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.server.expect().withPath("/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true")).andReturnChunked(200, new Object[]{outdatedEvent, "\n"})).once();
        Watch watch = (Watch)((Watchable)((PodResource)client.pods().withName("pod1")).withResourceVersion("1")).watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod resource) {
                throw new AssertionFailedError();
            }

            public void onClose(KubernetesClientException cause) {
                throw new AssertionFailedError();
            }
        });
        Throwable throwable = null;
        if (watch != null) {
            if (throwable != null) {
                try {
                    watch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                watch.close();
            }
        }
    }

    @Test
    public void testHttpErrorReconnect() throws InterruptedException {
        this.logger.info("testHttpErrorReconnect");
        KubernetesClient client = (KubernetesClient)this.server.getClient().inNamespace("test");
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.server.expect().withPath("/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true")).andReturn(200, (Object)"Failed WebSocket Connection")).once();
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.server.expect().withPath("/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true")).andReturnChunked(503, new Object[]{((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(503))).build()})).times(6);
        ((TimesOrOnceable)((ReturnOrWebsocketable)this.server.expect().withPath("/api/v1/namespaces/test/pods?fieldSelector=metadata.name%3Dpod1&resourceVersion=1&watch=true")).andReturnChunked(200, new Object[]{outdatedEvent, "\n"})).once();
        final CountDownLatch closeLatch = new CountDownLatch(1);
        try (Watch watch = (Watch)((Watchable)((PodResource)client.pods().withName("pod1")).withResourceVersion("1")).watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod resource) {
                throw new AssertionFailedError();
            }

            public void onClose(KubernetesClientException cause) {
                WatchOverHTTP.this.logger.debug("onClose", (Throwable)cause);
                closeLatch.countDown();
            }
        });){
            Assert.assertTrue((boolean)closeLatch.await(3L, TimeUnit.MINUTES));
        }
    }
}

