
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.extensions.DoneableIngress;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.DoneableIngress;

import java.util.Map;
import java.util.TreeMap;


public class IngressOperationsImpl extends HasMetadataOperation<Ingress, IngressList, DoneableIngress, Resource<Ingress, DoneableIngress>> {

  public IngressOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public IngressOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public IngressOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("extensions")
    .withApiGroupVersion("v1beta1")
    .withPlural("ingresses"));
    this.type = Ingress.class;
    this.listType = IngressList.class;
    this.doneableType = DoneableIngress.class;
  }

  public IngressOperationsImpl newInstance(OperationContext context) {
    return new IngressOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
