
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.apiextensions.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.apiextensions.v1.DoneableCustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.apiextensions.v1.DoneableCustomResourceDefinition;

import java.util.Map;
import java.util.TreeMap;


public class CustomResourceDefinitionOperationsImpl extends HasMetadataOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> {

  public CustomResourceDefinitionOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public CustomResourceDefinitionOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public CustomResourceDefinitionOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("apiextensions.k8s.io")
    .withApiGroupVersion("v1")
    .withPlural("customresourcedefinitions"));
    this.type = CustomResourceDefinition.class;
    this.listType = CustomResourceDefinitionList.class;
    this.doneableType = DoneableCustomResourceDefinition.class;
  }

  public CustomResourceDefinitionOperationsImpl newInstance(OperationContext context) {
    return new CustomResourceDefinitionOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
