
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.storage.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.storage.v1beta1.DoneableCSINode;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINode;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeList;
import io.fabric8.kubernetes.api.model.storage.v1beta1.DoneableCSINode;

import java.util.Map;
import java.util.TreeMap;


public class CSINodeOperationsImpl extends HasMetadataOperation<CSINode, CSINodeList, DoneableCSINode, Resource<CSINode, DoneableCSINode>> {

  public CSINodeOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public CSINodeOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public CSINodeOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("storage.k8s.io")
    .withApiGroupVersion("v1beta1")
    .withPlural("csinodes"));
    this.type = CSINode.class;
    this.listType = CSINodeList.class;
    this.doneableType = DoneableCSINode.class;
  }

  public CSINodeOperationsImpl newInstance(OperationContext context) {
    return new CSINodeOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
