/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.cache.DeltaFIFO;
import java.time.ZonedDateTime;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorListener<T>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ProcessorListener.class);
    private static final int DEFAULT_QUEUE_CAPACITY = 1000;
    private long resyncPeriod;
    private ZonedDateTime nextResync;
    private BlockingQueue<Notification> queue;
    private ResourceEventHandler<T> handler;

    public ProcessorListener(ResourceEventHandler<T> handler, long resyncPeriod) {
        this.resyncPeriod = resyncPeriod;
        this.handler = handler;
        this.queue = new ArrayBlockingQueue<Notification>(1000);
        this.determineNextResync(ZonedDateTime.now());
    }

    @Override
    public void run() {
        try {
            while (true) {
                Notification notification;
                Notification obj;
                if ((obj = this.queue.take()) instanceof UpdateNotification) {
                    notification = (UpdateNotification)obj;
                    this.handler.onUpdate(((UpdateNotification)notification).getOldObj(), ((UpdateNotification)notification).getNewObj());
                    continue;
                }
                if (obj instanceof AddNotification) {
                    notification = (AddNotification)obj;
                    this.handler.onAdd(((AddNotification)notification).getNewObj());
                    continue;
                }
                if (!(obj instanceof DeleteNotification)) break;
                Object deletedObj = ((DeleteNotification)obj).getOldObj();
                if (deletedObj instanceof DeltaFIFO.DeletedFinalStateUnknown) {
                    this.handler.onDelete(((DeltaFIFO.DeletedFinalStateUnknown)deletedObj).getObj(), true);
                    continue;
                }
                this.handler.onDelete(deletedObj, false);
            }
            throw new RuntimeException("unrecognized notification");
        }
        catch (InterruptedException e) {
            log.error("processor interrupted: {}", (Object)e.getMessage());
            return;
        }
    }

    public void add(Notification<T> obj) {
        if (obj == null) {
            return;
        }
        this.queue.add(obj);
    }

    public void determineNextResync(ZonedDateTime now) {
        this.nextResync = now.plusSeconds(this.resyncPeriod);
    }

    public boolean shouldResync(ZonedDateTime now) {
        return this.resyncPeriod != 0L && (now.isAfter(this.nextResync) || now.equals(this.nextResync));
    }

    public static final class DeleteNotification<T>
    extends Notification<T> {
        private T oldObj;

        public DeleteNotification(T oldObj) {
            this.oldObj = oldObj;
        }

        T getOldObj() {
            return this.oldObj;
        }
    }

    public static final class AddNotification<T>
    extends Notification<T> {
        private T newObj;

        public AddNotification(T newObj) {
            this.newObj = newObj;
        }

        T getNewObj() {
            return this.newObj;
        }
    }

    public static final class UpdateNotification<T>
    extends Notification<T> {
        private T oldObj;
        private T newObj;

        public UpdateNotification(T oldObj, T newObj) {
            this.oldObj = oldObj;
            this.newObj = newObj;
        }

        T getOldObj() {
            return this.oldObj;
        }

        T getNewObj() {
            return this.newObj;
        }
    }

    public static class Notification<T> {
    }
}

