/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;

public class OperationContext {
    protected OkHttpClient client;
    protected Config config;
    protected Object item;
    protected String resourceVersion;
    protected String plural;
    protected String apiGroupName;
    protected String apiGroupVersion;
    protected String namespace;
    protected String name;
    protected boolean cascading;
    protected boolean reloadingFromServer;
    protected long gracePeriodSeconds = -1L;
    protected String propagationPolicy;
    protected Map<String, String> labels;
    protected Map<String, String[]> labelsNot;
    protected Map<String, String[]> labelsIn;
    protected Map<String, String[]> labelsNotIn;
    protected Map<String, String> fields;
    protected Map<String, String[]> fieldsNot;

    public OperationContext() {
    }

    public OperationContext(OkHttpClient client, Config config, String plural, String namespace, String name, String apiGroupName, String apiGroupVersion, boolean cascading, Object item, Map<String, String> labels, Map<String, String[]> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Map<String, String[]> fieldsNot, String resourceVersion, boolean reloadingFromServer, long gracePeriodSeconds, String propagationPolicy) {
        this.client = client;
        this.config = config;
        this.plural = plural;
        this.namespace = Utils.isNotNullOrEmpty(namespace) ? namespace : (config != null ? config.getNamespace() : null);
        this.name = name;
        this.cascading = cascading;
        this.labels = labels != null ? labels : new HashMap();
        this.labelsNot = labelsNot != null ? labelsNot : new HashMap();
        this.labelsIn = labelsIn != null ? labelsIn : new HashMap();
        this.labelsNotIn = labelsNotIn != null ? labelsNotIn : new HashMap();
        this.fields = fields != null ? fields : new HashMap();
        this.fieldsNot = fieldsNot != null ? fieldsNot : new HashMap();
        this.resourceVersion = resourceVersion;
        this.reloadingFromServer = reloadingFromServer;
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.propagationPolicy = propagationPolicy;
        this.item = item;
        this.apiGroupName = ApiVersionUtil.apiGroup(item, apiGroupName);
        this.apiGroupVersion = ApiVersionUtil.apiVersion(item, apiGroupVersion);
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getPlural() {
        return this.plural;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getApiGroupName() {
        return this.apiGroupName;
    }

    public String getApiGroupVersion() {
        return this.apiGroupVersion;
    }

    public boolean getCascading() {
        return this.cascading;
    }

    public Object getItem() {
        return this.item;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String[]> getLabelsNot() {
        return this.labelsNot;
    }

    public Map<String, String[]> getLabelsIn() {
        return this.labelsIn;
    }

    public Map<String, String[]> getLabelsNotIn() {
        return this.labelsNotIn;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public Map<String, String[]> getFieldsNot() {
        return this.fieldsNot;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public boolean getReloadingFromServer() {
        return this.reloadingFromServer;
    }

    public long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public OperationContext withOkhttpClient(OkHttpClient client) {
        return new OperationContext(client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withConfig(Config config) {
        return new OperationContext(this.client, config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withPlural(String plural) {
        return new OperationContext(this.client, this.config, plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withNamespace(String namespace) {
        return new OperationContext(this.client, this.config, this.plural, namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withName(String name) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withApiGroupName(String apiGroupName) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withApiGroupVersion(String apiGroupVersion) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withItem(Object item) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withCascading(boolean cascading) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withLabels(Map<String, String> labels) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withLabelsIn(Map<String, String[]> labelsIn) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withLabelsNot(Map<String, String[]> labelsNot) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withLabelsNotIn(Map<String, String[]> labelsNotIn) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withFields(Map<String, String> fields) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withFieldsNot(Map<String, String[]> fieldsNot) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withResourceVersion(String resourceVersion) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withReloadingFromServer(boolean reloadingFromServer) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withGracePeriodSeconds(long gracePeriodSeconds) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, gracePeriodSeconds, this.propagationPolicy);
    }

    public OperationContext withPropagationPolicy(String propagationPolicy) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, propagationPolicy);
    }
}

