/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollableScalableResourceOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends HasMetadataOperation<T, L, R>
implements RollableScalableResource<T> {
    private static final Logger Log = LoggerFactory.getLogger(RollableScalableResourceOperation.class);
    final boolean rolling;
    final long rollingTimeout;
    final TimeUnit rollingTimeUnit;

    public RollableScalableResourceOperation(RollingOperationContext context) {
        super(context);
        this.rolling = context.getRolling();
        this.rollingTimeout = context.getRollingTimeout();
        this.rollingTimeUnit = context.getRollingTimeUnit();
    }

    protected abstract T withReplicas(int var1);

    protected abstract RollingUpdater<T, L> getRollingUpdater(long var1, TimeUnit var3);

    protected abstract int getCurrentReplicas(T var1);

    protected abstract int getDesiredReplicas(T var1);

    protected abstract long getObservedGeneration(T var1);

    @Override
    public T scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public T scale(int count, boolean wait) {
        T res = this.withReplicas(count);
        if (wait) {
            this.waitUntilScaled(count);
            res = this.getMandatory();
        }
        return res;
    }

    @Override
    public Scale scale() {
        return this.handleScale(null);
    }

    @Override
    public Scale scale(Scale scaleParam) {
        return this.handleScale(scaleParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilScaled(int count) {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        Runnable tPoller = () -> {
            try {
                Object t = this.get();
                if (t == null) {
                    if (count == 0) {
                        queue.put(true);
                    } else {
                        queue.put(new IllegalStateException("Can't wait for " + this.getType().getSimpleName() + ": " + name + " in namespace: " + namespace + " to scale. Resource is no longer available."));
                    }
                    return;
                }
                int currentReplicas = this.getCurrentReplicas(t);
                int desiredReplicas = this.getDesiredReplicas(t);
                replicasRef.set(currentReplicas);
                long generation = t.getMetadata().getGeneration() != null ? t.getMetadata().getGeneration() : -1L;
                long observedGeneration = this.getObservedGeneration(t);
                if (observedGeneration >= generation && Objects.equals(desiredReplicas, currentReplicas)) {
                    queue.put(true);
                }
                Log.debug("Only {}/{} replicas scheduled for {}: {} in namespace: {} seconds so waiting...", new Object[]{currentReplicas, desiredReplicas, t.getKind(), t.getMetadata().getName(), namespace});
            }
            catch (Throwable t) {
                Log.error("Error while waiting for resource to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(tPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
                Log.debug("{}/{} pod(s) ready for {}: {} in namespace: {}.", new Object[]{replicasRef.get(), count, this.getType().getSimpleName(), name, namespace});
            } else {
                Log.error("{}/{} pod(s) ready for {}: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, this.getType().getSimpleName(), name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    @Override
    public T edit(UnaryOperator<T> function) {
        if (!this.rolling) {
            return super.edit(function);
        }
        try {
            Object oldObj = this.getMandatory();
            HasMetadata newObj = (HasMetadata)function.apply(oldObj);
            return (T)this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate((HasMetadata)oldObj, newObj);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T replace(T t) {
        if (!this.rolling) {
            return super.replace(t);
        }
        return this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate(this.getMandatory(), t);
    }

    @Override
    public T patch(PatchContext patchContext, T item) {
        if (!this.rolling) {
            return super.patch(patchContext, item);
        }
        return this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate(this.getMandatory(), item);
    }
}

