/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.impl;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Informable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedInformerFactoryImpl
implements SharedInformerFactory {
    private static final Logger log = LoggerFactory.getLogger(SharedInformerFactoryImpl.class);
    private final List<SharedIndexInformer<?>> informers = new ArrayList();
    private final ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners = new ConcurrentLinkedQueue();
    private String name;
    private String namespace;
    private KubernetesClient client;

    public SharedInformerFactoryImpl(KubernetesClient client) {
        this.client = client;
    }

    public SharedInformerFactory inNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public SharedInformerFactory withName(String name) {
        this.name = name;
        return this;
    }

    public synchronized <T extends HasMetadata> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, long resyncPeriodInMillis) {
        MixedOperation resources = this.client.resources(apiTypeClass);
        Informable informable = null;
        if (this.namespace != null) {
            NonNamespaceOperation nonNamespaceOp = (NonNamespaceOperation)resources.inNamespace(this.namespace);
            informable = nonNamespaceOp;
            if (this.name != null) {
                informable = (Informable)nonNamespaceOp.withName(this.name);
            }
        } else {
            informable = this.name != null ? (Informable)resources.withName(this.name) : (Informable)resources.inAnyNamespace();
        }
        SharedIndexInformer informer = informable.runnableInformer(resyncPeriodInMillis);
        this.informers.add(informer);
        return informer;
    }

    public synchronized <T> SharedIndexInformer<T> getExistingSharedIndexInformer(Class<T> apiTypeClass) {
        for (SharedIndexInformer<?> informer : this.informers) {
            if (!informer.getApiTypeClass().equals(apiTypeClass)) continue;
            return informer;
        }
        return null;
    }

    public synchronized Future<Void> startAllRegisteredInformers() {
        ArrayList<CompletableFuture> startInformerTasks = new ArrayList<CompletableFuture>();
        if (!this.informers.isEmpty()) {
            for (SharedIndexInformer<?> informer : this.informers) {
                CompletableFuture future = informer.start();
                startInformerTasks.add(future);
                future.whenComplete((v, t) -> {
                    if (t != null) {
                        if (this.eventListeners.isEmpty()) {
                            log.warn("Failed to start informer {}", (Object)informer.toString(), t);
                        } else {
                            this.eventListeners.forEach(listener -> listener.onException(informer, (Exception)KubernetesClientException.launderThrowable((Throwable)t)));
                        }
                    }
                });
            }
        }
        return CompletableFuture.allOf(startInformerTasks.toArray(new CompletableFuture[0]));
    }

    public synchronized void stopAllRegisteredInformers() {
        this.informers.forEach(SharedIndexInformer::stop);
    }

    public void addSharedInformerEventListener(SharedInformerEventListener event) {
        this.eventListeners.add(event);
    }
}

