package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RuleFluentImpl<A extends RuleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RuleFluent<A> {

    private List<String> apiGroups = new ArrayList<String>();
    private List<String> apiVersions = new ArrayList<String>();
    private List<String> resources = new ArrayList<String>();
    private String scope;

    public RuleFluentImpl() { 
    }


    public RuleFluentImpl(Rule instance) { 
        this.withApiGroups(instance.getApiGroups()); 
        this.withApiVersions(instance.getApiVersions()); 
        this.withResources(instance.getResources()); 
        this.withScope(instance.getScope()); 
    }


    public A addToApiGroups(int index,String item) {
        if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
        this.apiGroups.add(index, item);
        return (A)this;
    }

    public A setToApiGroups(int index,String item) {
        if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
        this.apiGroups.set(index, item); return (A)this;
    }

    public A addToApiGroups(String... items) {
        if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
        for (String item : items) {this.apiGroups.add(item);} return (A)this;
    }

    public A addAllToApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
        for (String item : items) {this.apiGroups.add(item);} return (A)this;
    }

    public A removeFromApiGroups(String... items) {
        for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
    }

    public A removeAllFromApiGroups(Collection<String> items) {
        for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
    }

    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public String getApiGroup(int index) {
        return this.apiGroups.get(index);
    }

    public String getFirstApiGroup() {
        return this.apiGroups.get(0);
    }

    public String getLastApiGroup() {
        return this.apiGroups.get(apiGroups.size() - 1);
    }

    public String getMatchingApiGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: apiGroups) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingApiGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: apiGroups) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withApiGroups(List<String> apiGroups) {
        if (this.apiGroups != null) { _visitables.get("apiGroups").removeAll(this.apiGroups);}
        if (apiGroups != null) {this.apiGroups = new ArrayList<String>(); for (String item : apiGroups){this.addToApiGroups(item);}} else { this.apiGroups = null;} return (A) this;
    }

    public A withApiGroups(String... apiGroups) {
        if (this.apiGroups != null) {this.apiGroups.clear();}
        if (apiGroups != null) {for (String item :apiGroups){ this.addToApiGroups(item);}} return (A) this;
    }

    public Boolean hasApiGroups() {
        return apiGroups != null && !apiGroups.isEmpty();
    }

    public A addNewApiGroup(String arg1) {
        return (A)addToApiGroups(new String(arg1));
    }

    public A addNewApiGroup(StringBuilder arg1) {
        return (A)addToApiGroups(new String(arg1));
    }

    public A addNewApiGroup(StringBuffer arg1) {
        return (A)addToApiGroups(new String(arg1));
    }

    public A addToApiVersions(int index,String item) {
        if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
        this.apiVersions.add(index, item);
        return (A)this;
    }

    public A setToApiVersions(int index,String item) {
        if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
        this.apiVersions.set(index, item); return (A)this;
    }

    public A addToApiVersions(String... items) {
        if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
        for (String item : items) {this.apiVersions.add(item);} return (A)this;
    }

    public A addAllToApiVersions(Collection<String> items) {
        if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
        for (String item : items) {this.apiVersions.add(item);} return (A)this;
    }

    public A removeFromApiVersions(String... items) {
        for (String item : items) {if (this.apiVersions!= null){ this.apiVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromApiVersions(Collection<String> items) {
        for (String item : items) {if (this.apiVersions!= null){ this.apiVersions.remove(item);}} return (A)this;
    }

    public List<String> getApiVersions() {
        return this.apiVersions;
    }

    public String getApiVersion(int index) {
        return this.apiVersions.get(index);
    }

    public String getFirstApiVersion() {
        return this.apiVersions.get(0);
    }

    public String getLastApiVersion() {
        return this.apiVersions.get(apiVersions.size() - 1);
    }

    public String getMatchingApiVersion(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: apiVersions) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingApiVersion(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: apiVersions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withApiVersions(List<String> apiVersions) {
        if (this.apiVersions != null) { _visitables.get("apiVersions").removeAll(this.apiVersions);}
        if (apiVersions != null) {this.apiVersions = new ArrayList<String>(); for (String item : apiVersions){this.addToApiVersions(item);}} else { this.apiVersions = null;} return (A) this;
    }

    public A withApiVersions(String... apiVersions) {
        if (this.apiVersions != null) {this.apiVersions.clear();}
        if (apiVersions != null) {for (String item :apiVersions){ this.addToApiVersions(item);}} return (A) this;
    }

    public Boolean hasApiVersions() {
        return apiVersions != null && !apiVersions.isEmpty();
    }

    public A addNewApiVersion(String arg1) {
        return (A)addToApiVersions(new String(arg1));
    }

    public A addNewApiVersion(StringBuilder arg1) {
        return (A)addToApiVersions(new String(arg1));
    }

    public A addNewApiVersion(StringBuffer arg1) {
        return (A)addToApiVersions(new String(arg1));
    }

    public A addToResources(int index,String item) {
        if (this.resources == null) {this.resources = new ArrayList<String>();}
        this.resources.add(index, item);
        return (A)this;
    }

    public A setToResources(int index,String item) {
        if (this.resources == null) {this.resources = new ArrayList<String>();}
        this.resources.set(index, item); return (A)this;
    }

    public A addToResources(String... items) {
        if (this.resources == null) {this.resources = new ArrayList<String>();}
        for (String item : items) {this.resources.add(item);} return (A)this;
    }

    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {this.resources = new ArrayList<String>();}
        for (String item : items) {this.resources.add(item);} return (A)this;
    }

    public A removeFromResources(String... items) {
        for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
    }

    public A removeAllFromResources(Collection<String> items) {
        for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String getResource(int index) {
        return this.resources.get(index);
    }

    public String getFirstResource() {
        return this.resources.get(0);
    }

    public String getLastResource() {
        return this.resources.get(resources.size() - 1);
    }

    public String getMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: resources) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: resources) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withResources(List<String> resources) {
        if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
        if (resources != null) {this.resources = new ArrayList<String>(); for (String item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
    }

    public A withResources(String... resources) {
        if (this.resources != null) {this.resources.clear();}
        if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources() {
        return resources != null && !resources.isEmpty();
    }

    public A addNewResource(String arg1) {
        return (A)addToResources(new String(arg1));
    }

    public A addNewResource(StringBuilder arg1) {
        return (A)addToResources(new String(arg1));
    }

    public A addNewResource(StringBuffer arg1) {
        return (A)addToResources(new String(arg1));
    }

    public String getScope() {
        return this.scope;
    }

    public A withScope(String scope) {
        this.scope=scope; return (A) this;
    }

    public Boolean hasScope() {
        return this.scope != null;
    }

    public A withNewScope(String arg1) {
        return (A)withScope(new String(arg1));
    }

    public A withNewScope(StringBuilder arg1) {
        return (A)withScope(new String(arg1));
    }

    public A withNewScope(StringBuffer arg1) {
        return (A)withScope(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RuleFluentImpl that = (RuleFluentImpl) o;
        if (apiGroups != null ? !apiGroups.equals(that.apiGroups) :that.apiGroups != null) return false;
        if (apiVersions != null ? !apiVersions.equals(that.apiVersions) :that.apiVersions != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiGroups,  apiVersions,  resources,  scope,  super.hashCode());
    }

}
