package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MutatingWebhookConfigurationBuilder extends MutatingWebhookConfigurationFluentImpl<MutatingWebhookConfigurationBuilder> implements VisitableBuilder<MutatingWebhookConfiguration,MutatingWebhookConfigurationBuilder> {

    MutatingWebhookConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public MutatingWebhookConfigurationBuilder() {
        this(true);
    }

    public MutatingWebhookConfigurationBuilder(Boolean validationEnabled) {
        this(new MutatingWebhookConfiguration(), validationEnabled);
    }

    public MutatingWebhookConfigurationBuilder(MutatingWebhookConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public MutatingWebhookConfigurationBuilder(MutatingWebhookConfigurationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new MutatingWebhookConfiguration(), validationEnabled);
    }

    public MutatingWebhookConfigurationBuilder(MutatingWebhookConfigurationFluent<?> fluent,MutatingWebhookConfiguration instance) {
        this(fluent, instance, true);
    }

    public MutatingWebhookConfigurationBuilder(MutatingWebhookConfigurationFluent<?> fluent,MutatingWebhookConfiguration instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withWebhooks(instance.getWebhooks()); 
        this.validationEnabled = validationEnabled; 
    }

    public MutatingWebhookConfigurationBuilder(MutatingWebhookConfiguration instance) {
        this(instance,true);
    }

    public MutatingWebhookConfigurationBuilder(MutatingWebhookConfiguration instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withWebhooks(instance.getWebhooks()); 
        this.validationEnabled = validationEnabled; 
    }

    public MutatingWebhookConfiguration build() {
        MutatingWebhookConfiguration buildable = new MutatingWebhookConfiguration(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getWebhooks());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MutatingWebhookConfigurationBuilder that = (MutatingWebhookConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
