package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuleWithOperationsBuilder extends io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperationsFluentImpl<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperationsBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperations,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperationsBuilder> {

    io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperationsFluent<?> fluent;
    Boolean validationEnabled;

    public RuleWithOperationsBuilder() {
        this(true);
    }

    public RuleWithOperationsBuilder(Boolean validationEnabled) {
        this(new RuleWithOperations(), validationEnabled);
    }

    public RuleWithOperationsBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperationsFluent<?> fluent) {
        this(fluent, true);
    }

    public RuleWithOperationsBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperationsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RuleWithOperations(), validationEnabled);
    }

    public RuleWithOperationsBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperationsFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperations instance) {
        this(fluent, instance, true);
    }

    public RuleWithOperationsBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperationsFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperations instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiGroups(instance.getApiGroups()); 
        fluent.withApiVersions(instance.getApiVersions()); 
        fluent.withOperations(instance.getOperations()); 
        fluent.withResources(instance.getResources()); 
        fluent.withScope(instance.getScope()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuleWithOperationsBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperations instance) {
        this(instance,true);
    }

    public RuleWithOperationsBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperations instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiGroups(instance.getApiGroups()); 
        this.withApiVersions(instance.getApiVersions()); 
        this.withOperations(instance.getOperations()); 
        this.withResources(instance.getResources()); 
        this.withScope(instance.getScope()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleWithOperations build() {
        RuleWithOperations buildable = new RuleWithOperations(fluent.getApiGroups(),fluent.getApiVersions(),fluent.getOperations(),fluent.getResources(),fluent.getScope());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RuleWithOperationsBuilder that = (RuleWithOperationsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
