package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ValidatingWebhookConfigurationListBuilder extends io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationListFluentImpl<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationList,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationListBuilder> {

    io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationListFluent<?> fluent;
    Boolean validationEnabled;

    public ValidatingWebhookConfigurationListBuilder() {
        this(true);
    }

    public ValidatingWebhookConfigurationListBuilder(Boolean validationEnabled) {
        this(new ValidatingWebhookConfigurationList(), validationEnabled);
    }

    public ValidatingWebhookConfigurationListBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationListFluent<?> fluent) {
        this(fluent, true);
    }

    public ValidatingWebhookConfigurationListBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ValidatingWebhookConfigurationList(), validationEnabled);
    }

    public ValidatingWebhookConfigurationListBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationListFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationList instance) {
        this(fluent, instance, true);
    }

    public ValidatingWebhookConfigurationListBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationListFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ValidatingWebhookConfigurationListBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationList instance) {
        this(instance,true);
    }

    public ValidatingWebhookConfigurationListBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationList build() {
        ValidatingWebhookConfigurationList buildable = new ValidatingWebhookConfigurationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ValidatingWebhookConfigurationListBuilder that = (ValidatingWebhookConfigurationListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
