package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceAttributesBuilder extends io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesFluentImpl<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes,io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesBuilder> {

    io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceAttributesBuilder() {
        this(true);
    }

    public ResourceAttributesBuilder(Boolean validationEnabled) {
        this(new ResourceAttributes(), validationEnabled);
    }

    public ResourceAttributesBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceAttributesBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ResourceAttributes(), validationEnabled);
    }

    public ResourceAttributesBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesFluent<?> fluent,io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes instance) {
        this(fluent, instance, true);
    }

    public ResourceAttributesBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributesFluent<?> fluent,io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGroup(instance.getGroup()); 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withResource(instance.getResource()); 
        fluent.withSubresource(instance.getSubresource()); 
        fluent.withVerb(instance.getVerb()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceAttributesBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes instance) {
        this(instance,true);
    }

    public ResourceAttributesBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withGroup(instance.getGroup()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withResource(instance.getResource()); 
        this.withSubresource(instance.getSubresource()); 
        this.withVerb(instance.getVerb()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.ResourceAttributes build() {
        ResourceAttributes buildable = new ResourceAttributes(fluent.getGroup(),fluent.getName(),fluent.getNamespace(),fluent.getResource(),fluent.getSubresource(),fluent.getVerb(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceAttributesBuilder that = (ResourceAttributesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
