package io.fabric8.kubernetes.api.model.admission.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AdmissionResponseBuilder extends io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseFluentImpl<io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse,io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseBuilder> {

    io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseFluent<?> fluent;
    Boolean validationEnabled;

    public AdmissionResponseBuilder() {
        this(true);
    }

    public AdmissionResponseBuilder(Boolean validationEnabled) {
        this(new AdmissionResponse(), validationEnabled);
    }

    public AdmissionResponseBuilder(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseFluent<?> fluent) {
        this(fluent, true);
    }

    public AdmissionResponseBuilder(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AdmissionResponse(), validationEnabled);
    }

    public AdmissionResponseBuilder(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseFluent<?> fluent,io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse instance) {
        this(fluent, instance, true);
    }

    public AdmissionResponseBuilder(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseFluent<?> fluent,io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAllowed(instance.getAllowed()); 
        fluent.withAuditAnnotations(instance.getAuditAnnotations()); 
        fluent.withPatch(instance.getPatch()); 
        fluent.withPatchType(instance.getPatchType()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withUid(instance.getUid()); 
        fluent.withWarnings(instance.getWarnings()); 
        this.validationEnabled = validationEnabled; 
    }

    public AdmissionResponseBuilder(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse instance) {
        this(instance,true);
    }

    public AdmissionResponseBuilder(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAllowed(instance.getAllowed()); 
        this.withAuditAnnotations(instance.getAuditAnnotations()); 
        this.withPatch(instance.getPatch()); 
        this.withPatchType(instance.getPatchType()); 
        this.withStatus(instance.getStatus()); 
        this.withUid(instance.getUid()); 
        this.withWarnings(instance.getWarnings()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse build() {
        AdmissionResponse buildable = new AdmissionResponse(fluent.getAllowed(),fluent.getAuditAnnotations(),fluent.getPatch(),fluent.getPatchType(),fluent.getStatus(),fluent.getUid(),fluent.getWarnings());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AdmissionResponseBuilder that = (AdmissionResponseBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
