package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MutatingWebhookConfigurationBuilder extends io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfigurationFluentImpl<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfigurationBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfiguration,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfigurationBuilder> {

    io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public MutatingWebhookConfigurationBuilder() {
        this(true);
    }

    public MutatingWebhookConfigurationBuilder(Boolean validationEnabled) {
        this(new MutatingWebhookConfiguration(), validationEnabled);
    }

    public MutatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public MutatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfigurationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new MutatingWebhookConfiguration(), validationEnabled);
    }

    public MutatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfigurationFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfiguration instance) {
        this(fluent, instance, true);
    }

    public MutatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfigurationFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfiguration instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withWebhooks(instance.getWebhooks()); 
        this.validationEnabled = validationEnabled; 
    }

    public MutatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfiguration instance) {
        this(instance,true);
    }

    public MutatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfiguration instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withWebhooks(instance.getWebhooks()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfiguration build() {
        MutatingWebhookConfiguration buildable = new MutatingWebhookConfiguration(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getWebhooks());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MutatingWebhookConfigurationBuilder that = (MutatingWebhookConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
