package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ValidatingWebhookConfigurationBuilder extends io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluentImpl<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfiguration,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationBuilder> {

    io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public ValidatingWebhookConfigurationBuilder() {
        this(true);
    }

    public ValidatingWebhookConfigurationBuilder(Boolean validationEnabled) {
        this(new ValidatingWebhookConfiguration(), validationEnabled);
    }

    public ValidatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public ValidatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ValidatingWebhookConfiguration(), validationEnabled);
    }

    public ValidatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfiguration instance) {
        this(fluent, instance, true);
    }

    public ValidatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfiguration instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withWebhooks(instance.getWebhooks()); 
        this.validationEnabled = validationEnabled; 
    }

    public ValidatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfiguration instance) {
        this(instance,true);
    }

    public ValidatingWebhookConfigurationBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfiguration instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withWebhooks(instance.getWebhooks()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfiguration build() {
        ValidatingWebhookConfiguration buildable = new ValidatingWebhookConfiguration(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getWebhooks());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ValidatingWebhookConfigurationBuilder that = (ValidatingWebhookConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
